/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.orc;

import java.awt.image.BufferedImage;
import java.net.Socket;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;
import org.orcboard.orc.AnalogInput;
import org.orcboard.orc.OrcConnection;
import org.orcboard.orc.OrcListener;
import org.orcboard.orc.OrcNativeConnection;
import org.orcboard.orc.OrcTCPConnection;
import org.orcboard.orc.Packet;

public class Orc {
    String host;
    int port;
    OrcConnection con;
    static final int PAD_STOP = 1;
    static final int PAD_A = 2;
    static final int PAD_B = 4;
    static final int PAD_STICK = 8;
    static final int PAD_UP = 16;
    static final int PAD_DOWN = 32;
    static final int PAD_LEFT = 64;
    static final int PAD_RIGHT = 128;
    static final int TICKS_PER_SEC = 15625;
    ArrayList<OrcListener> listeners = new ArrayList();
    ArrayBlockingQueue<Packet> asyncMessages = new ArrayBlockingQueue(128, false);
    boolean shuttingDown = false;
    static final int TIMEOUT_MS = 100;
    static final int CHUNKSIZE = 20;
    static final byte SPI_FLAG_LSB_FIRST = 1;
    static final byte SPI_FLAG_MSB_FIRST = 0;
    static final byte SPI_FLAG_HIGH_IDLE = 2;
    static final byte SPI_FLAG_LOW_IDLE = 0;
    static final byte SPI_FLAG_SAMP_TRAILING = 4;
    static final byte SPI_FLAG_SAMP_LEADING = 0;
    static final byte SPI_FLAG_DIV_CLK_4 = 0;
    static final byte SPI_FLAG_DIV_CLK_16 = 8;
    static final byte SPI_FLAG_DIV_CLK_32 = 16;
    static final byte SPI_FLAG_DIV_CLK_64 = 24;
    static final byte SPI_FLAG_MULT_CLK_2 = 32;
    static final byte SPI_FLAG_MODE_00 = 0;
    static final byte SPI_FLAG_MODE_01 = 2;
    static final byte SPI_FLAG_MODE_10 = 4;
    static final byte SPI_FLAG_MODE_11 = 6;
    static final byte SPI_SLAVE_AD0 = 0;
    static final byte SPI_SLAVE_AD1 = 1;
    static final byte SPI_SLAVE_FLASH = 2;
    static final byte SPI_SLAVE_EXTERN = 3;
    Transaction[] transactions;
    int idLast = 0;
    int idLow = 0;
    int idHigh = 239;
    int idUsed = 0;
    Object idObj = new Object();
    int nextTransaction = 0;
    AnalogInput batteryVoltageInput;
    Semaphore integratorSemaphore = new Semaphore(1);
    int pad_switches;
    int pad_joyx = 128;
    int pad_joyy = 128;
    int pad_updown = 0;
    int pad_leftright = 0;
    Object pad_sync = new Object();
    boolean pad_connected = false;

    static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static Orc makeOrc() {
        try {
            Socket sock = new Socket("localhost", 7000);
            sock.close();
            return new Orc(new OrcTCPConnection());
        }
        catch (Exception ex) {
            return new Orc(new OrcNativeConnection());
        }
    }

    public Orc(OrcConnection con) {
        this.con = con;
        this.transactions = new Transaction[256];
        for (int i = 0; i < 256; ++i) {
            this.transactions[i] = new Transaction();
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        new ReaderThread().start();
        new AsyncThread().start();
        this.doOrcNull(0, 0);
        this.batteryVoltageInput = new AnalogInput(this, 23);
    }

    public double getBatteryVoltage() {
        return this.batteryVoltageInput.read() * 11.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(OrcListener ol) {
        ArrayList<OrcListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(ol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(OrcListener ol) {
        ArrayList<OrcListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (this.listeners.contains(ol)) {
                this.listeners.remove(ol);
            }
        }
    }

    protected void handleAsyncMessage(Packet p) {
        while (true) {
            try {
                this.asyncMessages.put(p);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public byte[] doTransactionRetry(byte[] request) {
        byte[] response;
        if (this.shuttingDown) {
            while (true) {
                Orc.safesleep(100);
            }
        }
        do {
            if ((response = this.doTransactionOnce(request)) == null || response.length <= 0 || response[0] == 0 || response[0] == 5) continue;
            this.commandFailure(response[0]);
        } while (response == null || response.length < 1 || response[0] != 0);
        return response;
    }

    protected void commandFailure(int code) {
        String msg = "Unknown error";
        switch (code) {
            case 1: {
                msg = "Unknown command";
                break;
            }
            case 2: {
                msg = "Incorrect number of arguments";
                break;
            }
            case 3: {
                msg = "Invalid argument";
                break;
            }
            case 5: {
                msg = "Command failed";
                break;
            }
            case 6: {
                msg = "Busy- try again later";
            }
        }
        throw new RuntimeException(msg);
    }

    public void doTransactionAsync(byte[] request) {
        this.con.writePacket(new Packet(255, request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doTransactionOnce(byte[] request) {
        Transaction t;
        int id;
        Object object = this.idObj;
        synchronized (object) {
            int max = this.idHigh - this.idLow + 1;
            while (this.idUsed >= max) {
                try {
                    this.idObj.wait();
                }
                catch (InterruptedException ex) {}
            }
            do {
                ++this.idLast;
                if (this.idLast <= this.idHigh) continue;
                this.idLast = this.idLow;
            } while (this.transactions[this.idLast].inuse);
            id = this.idLast;
            ++this.idUsed;
            t = this.transactions[id];
            t = this.transactions[id];
            t.inuse = true;
            t.response = null;
        }
        this.con.writePacket(new Packet(id, request));
        object = t;
        synchronized (object) {
            if (t.response == null) {
                try {
                    t.wait(100L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
        byte[] response = t.response;
        t.inuse = false;
        Object object2 = this.idObj;
        synchronized (object2) {
            --this.idUsed;
            this.idObj.notifyAll();
        }
        return response;
    }

    public void doTransactionRetryVoid(byte[] request) {
        this.doTransactionRetry(request);
    }

    public int doTransactionRetry8(byte[] request) {
        byte[] resp = this.doTransactionRetry(request);
        return resp[1] & 0xFF;
    }

    public int doTransactionRetry16(byte[] request) {
        byte[] resp = this.doTransactionRetry(request);
        return ((resp[1] & 0xFF) << 8) + (resp[2] & 0xFF);
    }

    public int doTransactionRetry32(byte[] request) {
        byte[] resp = this.doTransactionRetry(request);
        return ((resp[1] & 0xFF) << 24) + ((resp[2] & 0xFF) << 16) + ((resp[3] & 0xFF) << 8) + (resp[4] & 0xFF);
    }

    public static int get16u(byte[] resp, int offset) {
        if (resp == null) {
            return 0;
        }
        if (offset + 1 >= resp.length) {
            return 0;
        }
        return ((resp[offset] & 0xFF) << 8) + (resp[offset + 1] & 0xFF);
    }

    public static int get16s(byte[] resp, int offset) {
        if (resp == null) {
            return 0;
        }
        if (offset + 1 >= resp.length) {
            return 0;
        }
        return resp[offset] << 8 | resp[offset + 1] & 0xFF;
    }

    public static int get32u(byte[] resp, int offset) {
        if (resp == null) {
            return 0;
        }
        if (offset + 3 >= resp.length) {
            return 0;
        }
        return ((resp[offset + 0] & 0xFF) << 24) + ((resp[offset + 1] & 0xFF) << 16) + ((resp[offset + 2] & 0xFF) << 8) + ((resp[offset + 3] & 0xFF) << 0);
    }

    public static int get32s(byte[] resp, int offset) {
        if (resp == null) {
            return 0;
        }
        if (offset + 3 >= resp.length) {
            return 0;
        }
        return (resp[offset + 0] << 24) + ((resp[offset + 1] & 0xFF) << 16) + ((resp[offset + 2] & 0xFF) << 8) + ((resp[offset + 3] & 0xFF) << 0);
    }

    public byte[] doOrcNull(int reqlen, int resplen) {
        byte[] req = new byte[reqlen + 2];
        req[0] = 17;
        req[1] = (byte)resplen;
        return this.doTransactionRetry(req);
    }

    public byte[] doPadNull(int reqlen, int resplen) {
        byte[] req = new byte[reqlen + 2];
        req[0] = -119;
        req[1] = (byte)resplen;
        return this.doTransactionOnce(req);
    }

    public byte[] i2cTransaction(int addr, byte[] writebuf, int readlen) {
        int writebuflen = 0;
        if (writebuf != null) {
            writebuflen = writebuf.length;
        }
        byte[] b = new byte[writebuflen + 3];
        b[0] = 16;
        b[1] = (byte)addr;
        b[2] = (byte)readlen;
        for (int i = 0; i < writebuflen; ++i) {
            b[3 + i] = writebuf[i];
        }
        byte[] resp = this.doTransactionRetry(b);
        if (resp[0] != 0) {
            System.out.println("i2c error: " + resp[0]);
            return null;
        }
        if (readlen == 0) {
            return null;
        }
        byte[] p = new byte[readlen];
        for (int i = 0; i < readlen; ++i) {
            p[i] = resp[i + 1];
        }
        return p;
    }

    protected static void showArray(byte[] p) {
        if (p == null) {
            System.out.println("null");
            return;
        }
        for (int i = 0; i < p.length; ++i) {
            System.out.print(String.format("%02X ", p[i]));
        }
        System.out.println("");
    }

    public static int diff16(long a, long b) {
        long SIZE = 65536L;
        long MAX = SIZE - 1L;
        long d = (a &= MAX) - (b &= MAX);
        if (d < -SIZE / 2L) {
            return (int)(SIZE + d);
        }
        if (d > SIZE / 2L) {
            return -((int)(SIZE - d));
        }
        return (int)d;
    }

    public void setPinMode(int pin, PinMode mode) {
        this.doTransactionRetryVoid(new byte[]{8, (byte)pin, (byte)mode.getValue()});
    }

    public int integratorRead() {
        return this.doTransactionRetry16(new byte[]{13});
    }

    public void integratorAcquire() {
        try {
            this.integratorSemaphore.acquire();
        }
        catch (InterruptedException ex) {
            System.out.println("Integrator acquisition interruptd");
        }
    }

    public void integratorRelease() {
        this.integratorSemaphore.release();
    }

    public void integratorSetInput(int pin) {
        this.doTransactionRetryVoid(new byte[]{14, (byte)pin});
    }

    public void setDigitalOutput(int pin, int v) {
        this.doTransactionRetryVoid(new byte[]{9, (byte)pin, (byte)v});
    }

    public static void safesleep(int ms) {
        while (ms > 0) {
            long starttime = System.currentTimeMillis();
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            long endtime = System.currentTimeMillis();
            ms = (int)((long)ms - (endtime - starttime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePadMessage(Packet p) {
        if (p.data[0] != 0) {
            return;
        }
        int new_pad_updown = p.data[2] & 0xFF;
        int new_pad_leftright = p.data[3] & 0xFF;
        int res = this.pad_switches = p.data[1] & 0xFF;
        if ((new_pad_updown & 0xF0) != (this.pad_updown & 0xF0)) {
            res |= 0x10;
        }
        if ((new_pad_updown & 0xF) != (this.pad_updown & 0xF)) {
            res |= 0x20;
        }
        if ((new_pad_leftright & 0xF0) != (this.pad_leftright & 0xF0)) {
            res |= 0x40;
        }
        if ((new_pad_leftright & 0xF) != (this.pad_leftright & 0xF)) {
            res |= 0x40;
        }
        this.pad_updown = new_pad_updown;
        this.pad_leftright = new_pad_leftright;
        this.pad_joyx = p.data[4] & 0xFF;
        this.pad_joyy = p.data[5] & 0xFF;
        Object object = this.pad_sync;
        synchronized (object) {
            this.pad_sync.notifyAll();
        }
        for (OrcListener l : this.listeners) {
            l.orcPadEvent(res, this.pad_joyx, this.pad_joyy);
        }
    }

    public ButtonState padPollBegin() {
        return new ButtonState();
    }

    public int padButtonGets() {
        ButtonState bs = new ButtonState();
        return bs.gets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void padButtonReleased() {
        Object object = this.pad_sync;
        synchronized (object) {
            while (this.pad_switches != 0) {
                try {
                    this.pad_sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean isPadConnected() {
        return this.pad_connected;
    }

    public double joyX() {
        return (double)(this.pad_joyx - 128) / 128.0;
    }

    public double joyY() {
        return (double)(this.pad_joyy - 128) / 128.0;
    }

    public void lcdClear() {
        this.doTransactionOnce(new byte[]{-127});
    }

    public void lcdWrite(int x, int y, byte[] data) {
        byte[] b = new byte[data.length + 2];
        b[0] = (byte)x;
        b[1] = (byte)y;
        for (int i = 0; i < data.length; ++i) {
            b[2 + i] = data[i];
        }
        this.doTransactionOnce(b);
    }

    public void lcdDrawString(int x, int y, int font, String s) {
        int len = s.length();
        for (int i = 0; i < len; i += 20) {
            int thislen = Orc.min(len - i, 20);
            byte[] req = new byte[thislen + 4];
            req[0] = -125;
            req[1] = (byte)x;
            req[2] = (byte)y;
            req[3] = (byte)font;
            for (int j = 0; j < thislen; ++j) {
                req[j + 1] = (byte)(s.charAt(i + j) & 0xFF);
            }
            byte[] resp = this.doTransactionOnce(req);
            x += resp[1] & 0xFF;
        }
    }

    public void lcdConsoleWrite(String s) {
        int len = s.length();
        for (int i = 0; i < len; i += 20) {
            int thislen = Orc.min(len - i, 20);
            byte[] req = new byte[thislen + 1];
            req[0] = -128;
            for (int j = 0; j < thislen; ++j) {
                req[j + 1] = (byte)(s.charAt(i + j) & 0xFF);
            }
            this.doTransactionOnce(req);
        }
    }

    public void lcdConsoleHome() {
        this.doTransactionOnce(new byte[]{-124});
    }

    public void lcdConsoleGoto(int col, int row) {
        this.doTransactionOnce(new byte[]{-123, (byte)col, (byte)row});
    }

    public void lcdDrawImage(int x, int y, BufferedImage i) {
        if (!this.isPadConnected()) {
            return;
        }
        int w = i.getWidth();
        int h = i.getHeight();
        int BLOCKSIZE = 16;
        byte[] data = new byte[BLOCKSIZE + 3];
        for (int y0 = 0; y0 < h; y0 += 8) {
            if (y + y0 > 56) continue;
            for (int x0 = 0; x0 < w; x0 += BLOCKSIZE) {
                if (x + x0 > 128 - BLOCKSIZE) continue;
                int thisblocksize = BLOCKSIZE;
                if (x0 + thisblocksize >= w) {
                    thisblocksize = w - x0;
                }
                data[0] = -122;
                data[1] = (byte)(x + x0);
                data[2] = (byte)(y + y0);
                for (int xt = 0; xt < thisblocksize; ++xt) {
                    int acc = 0;
                    for (int yt = 7; yt >= 0; --yt) {
                        int p = 0;
                        if (x0 + xt < w && y0 + yt < h) {
                            p = i.getRGB(x0 + xt, y0 + yt);
                        }
                        p = (p & 0xFF00) != 0 ? 0 : 1;
                        acc = acc << 1 | p;
                    }
                    data[3 + xt] = (byte)acc;
                }
                this.doTransactionAsync(data);
            }
        }
        this.doPadNull(0, 0);
    }

    public BufferedImage lcdReadImage() {
        BufferedImage bi = new BufferedImage(128, 64, 10);
        int xstride = 32;
        int ystride = 8;
        for (int y = 0; y < 64; y += ystride) {
            for (int x = 0; x < 128; x += xstride) {
                byte[] buf = this.doTransactionOnce(new byte[]{-121, (byte)x, (byte)y, (byte)xstride});
                if (buf == null || buf.length != xstride + 1) {
                    return null;
                }
                for (int xi = 0; xi < xstride; ++xi) {
                    int b = buf[1 + xi];
                    for (int yi = 0; yi < 8; ++yi) {
                        bi.setRGB(x + xi, y + yi, (b & 1) > 0 ? 0 : -1);
                        b >>= 1;
                    }
                }
            }
        }
        return bi;
    }

    public static void main(String[] args) {
        Orc orc = Orc.makeOrc();
        orc.lcdConsoleWrite("this is a very long message that exceeds the number of characters that can be transmitted in a single packet.");
    }

    class AsyncThread
    extends Thread {
        double lastOrcTime = Double.MAX_VALUE;

        public AsyncThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.run_ex();
                    }
                }
                catch (Exception ex) {
                    System.out.println("Exception: " + ex);
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run_ex() throws Exception {
            Packet p = null;
            do {
                try {
                    p = Orc.this.asyncMessages.take();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            } while (p == null);
            int msgtype = Orc.get16u(p.data, 1);
            if (msgtype == 48) {
                ArrayList<OrcListener> arrayList;
                boolean thispad;
                int sec = Orc.get16u(p.data, 3);
                int ticks = Orc.get16u(p.data, 5);
                double orcTime = (double)sec + (double)ticks / 15625.0;
                boolean bl = thispad = (p.data[7] & 2) != 0;
                if (thispad && !Orc.this.pad_connected) {
                    arrayList = Orc.this.listeners;
                    synchronized (arrayList) {
                        for (OrcListener ol : Orc.this.listeners) {
                            ol.orcPadConnected();
                        }
                    }
                }
                if (!thispad && Orc.this.pad_connected) {
                    arrayList = Orc.this.listeners;
                    synchronized (arrayList) {
                        for (OrcListener ol : Orc.this.listeners) {
                            ol.orcPadDisconnected();
                        }
                    }
                }
                Orc.this.pad_connected = thispad;
                if (Math.abs(orcTime - this.lastOrcTime) > 10.0) {
                    arrayList = Orc.this.listeners;
                    synchronized (arrayList) {
                        for (OrcListener ol : Orc.this.listeners) {
                            ol.orcReset();
                        }
                    }
                }
                this.lastOrcTime = orcTime;
                arrayList = Orc.this.listeners;
                synchronized (arrayList) {
                    for (OrcListener ol : Orc.this.listeners) {
                        ol.orcHeartBeat(orcTime);
                    }
                }
            }
        }
    }

    class ReaderThread
    extends Thread {
        public ReaderThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Packet p;
                if ((p = Orc.this.con.readPacket()) == null) {
                    continue;
                }
                if (p.getId() == 247) {
                    Orc.this.idLow = p.data[1];
                    Orc.this.idHigh = p.data[2];
                    Orc.this.idLast = Orc.this.idLow;
                    System.out.println(String.format("Got id range %02X-%02X", Orc.this.idLow, Orc.this.idHigh));
                }
                if (p.getId() == 254) {
                    Orc.this.handlePadMessage(p);
                    continue;
                }
                if (p.getId() >= 240) {
                    Orc.this.handleAsyncMessage(p);
                    continue;
                }
                Transaction t = Orc.this.transactions[p.getId()];
                t.response = p.data;
                Transaction transaction = t;
                synchronized (transaction) {
                    t.notifyAll();
                }
            }
        }
    }

    class ShutdownThread
    extends Thread {
        ShutdownThread() {
        }

        @Override
        public void run() {
            System.out.println("Program exiting, shutting down");
            Orc.this.shuttingDown = true;
            for (int tries = 0; tries < 2; ++tries) {
                for (int i = 0; i < 4; ++i) {
                    Orc.this.doTransactionOnce(new byte[]{1, (byte)i, 0});
                }
                Thread.yield();
            }
        }
    }

    public class ButtonState {
        int up;
        int down;
        int left;
        int right;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ButtonState() {
            Object object = Orc.this.pad_sync;
            synchronized (object) {
                this.up = Orc.this.pad_updown >> 4 & 0xF;
                this.down = Orc.this.pad_updown & 0xF;
                this.left = Orc.this.pad_leftright >> 4 & 0xF;
                this.right = Orc.this.pad_leftright & 0xF;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int gets() {
            int res = 0;
            while (res == 0) {
                Object object = Orc.this.pad_sync;
                synchronized (object) {
                    res = Orc.this.pad_switches;
                    int tup = Orc.this.pad_updown >> 4 & 0xF;
                    int tdown = Orc.this.pad_updown & 0xF;
                    int tleft = Orc.this.pad_leftright >> 4 & 0xF;
                    int tright = Orc.this.pad_leftright & 0xF;
                    if (this.up != tup) {
                        res |= 0x10;
                    }
                    if (this.down != tdown) {
                        res |= 0x20;
                    }
                    if (this.right != tright) {
                        res |= 0x80;
                    }
                    if (this.left != tleft) {
                        res |= 0x40;
                    }
                    this.up = tup;
                    this.down = tdown;
                    this.left = tleft;
                    this.right = tright;
                    if (res == 0) {
                        try {
                            Orc.this.pad_sync.wait();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
            }
            return res;
        }
    }

    public static enum PinMode {
        DIGIN(0),
        DIGOUT(1),
        PWM(3);

        int val;

        private PinMode(int val) {
            this.val = val;
        }

        int getValue() {
            return this.val;
        }
    }

    static class Transaction {
        boolean inuse = false;
        byte[] response;

        Transaction() {
        }
    }
}

