/*
 * Decompiled with CFR 0.152.
 */
package orc;

import orc.Orc;

public class ADIS16350 {
    Orc orc;
    int maxclk = 2000000;
    int spo = 1;
    int sph = 1;
    int nbits = 16;

    public ADIS16350(Orc orc) {
        this.orc = orc;
    }

    int readRegister(int addr) {
        int[] v = this.orc.spiTransaction(this.maxclk, this.spo, this.sph, this.nbits, new int[]{addr << 8, 0});
        return v[0];
    }

    static int convert14(int v) {
        if (((v &= 0x3FFF) & 0x2000) > 0) {
            v |= 0xFFFFC000;
        }
        return v;
    }

    void writeRegister(int addr) {
        int[] v = this.orc.spiTransaction(this.maxclk, this.spo, this.sph, this.nbits, new int[]{(addr | 0x80) << 8, 0});
    }

    public static void main(String[] args) {
        Orc orc = Orc.makeOrc();
        ADIS16350 adis = new ADIS16350(orc);
        double zpos = 0.0;
        long lastTime = System.currentTimeMillis();
        while (true) {
            double zrate = (double)ADIS16350.convert14(adis.readRegister(8)) * 0.07326;
            long thisTime = System.currentTimeMillis();
            System.out.printf("%15f %15f\n", zrate, zpos);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            double dt = (double)(thisTime - lastTime) / 1000.0;
            lastTime = thisTime;
            zpos += zrate * dt;
        }
    }
}

