/*
 * Decompiled with CFR 0.152.
 */
package orc;

import orc.AnalogInput;
import orc.Orc;

public class IRRangeSensor {
    AnalogInput ain;
    double Xd;
    double Xm;
    double Xb;
    double arcAngle = 0.08;
    double voltageStdDev = 0.025;

    public void setParameters(double Xd, double Xm, double Xb) {
        this.Xd = Xd;
        this.Xm = Xm;
        this.Xb = Xb;
    }

    public void setParameters(double Xd, double Xm, double Xb, double voltageStdDev) {
        this.Xd = Xd;
        this.Xm = Xm;
        this.Xb = Xb;
        this.voltageStdDev = voltageStdDev;
    }

    public static IRRangeSensor make2Y0A02(Orc orc, int port) {
        IRRangeSensor s = new IRRangeSensor(orc, port);
        s.Xd = -0.0618;
        s.Xm = 0.7389;
        s.Xb = -0.1141;
        return s;
    }

    public static IRRangeSensor makeGP2D12(Orc orc, int port) {
        IRRangeSensor s = new IRRangeSensor(orc, port);
        s.Xd = 0.0828;
        s.Xm = 0.1384;
        s.Xb = 0.2448;
        return s;
    }

    public IRRangeSensor(Orc orc, int port) {
        this.ain = new AnalogInput(orc, port);
    }

    public double getRange() {
        double v = this.ain.getVoltage();
        double range = this.Xm / (v - this.Xb) + this.Xd;
        if (range < 0.0 || range > 100.0) {
            return 0.0;
        }
        return range;
    }

    public double getRangeUncertainty() {
        double v = this.ain.getVoltage();
        double dddV = Math.abs(-this.Xm / (v - this.Xb) / (v - this.Xb));
        return this.voltageStdDev * dddV;
    }

    public static void main(String[] args) {
        Orc orc = Orc.makeOrc();
        IRRangeSensor ir = IRRangeSensor.makeGP2D12(orc, 0);
        while (true) {
            System.out.println(String.format("range: %8.3f m   uncertainty: %8.3f m", ir.getRange(), ir.getRangeUncertainty()));
            Orc.safesleep(100);
        }
    }
}

