/*
 * Decompiled with CFR 0.152.
 */
package orc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import orc.OrcListener;
import orc.OrcResponse;
import orc.OrcStatus;

public class Orc {
    DatagramSocket sock;
    ReaderThread reader;
    InetAddress orcAddr;
    int nextTransactionId;
    static final int ORC_PORT = 2378;
    static final double MIN_TIMEOUT = 0.002;
    static final double MAX_TIMEOUT = 0.01;
    double meanRTT = 0.002;
    public boolean verbose = false;
    HashMap<Integer, OrcResponse> transactionResponses = new HashMap();
    ArrayList<OrcListener> listeners = new ArrayList();

    public static void main(String[] args) {
        Orc orc = Orc.makeOrc();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static Orc makeOrc() {
        return Orc.makeOrc("192.168.1.7");
    }

    public static Orc makeOrc(String hostname) {
        while (true) {
            try {
                return new Orc(Inet4Address.getByName(hostname));
            }
            catch (IOException ex) {
                System.out.println("Exception creating Orc: " + ex);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public Orc(InetAddress inetaddr) throws IOException {
        this.orcAddr = inetaddr;
        this.sock = new DatagramSocket();
        this.reader = new ReaderThread();
        this.reader.setDaemon(true);
        this.reader.start();
    }

    public void addListener(OrcListener ol) {
        this.listeners.add(ol);
    }

    OrcResponse doCommand(int commandId, byte[] payload) {
        while (true) {
            try {
                return this.doCommandEx(commandId, payload);
            }
            catch (IOException ex) {
                System.out.println("ex: " + ex);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OrcResponse doCommandEx(int commandId, byte[] payload) throws IOException {
        boolean okay;
        int transactionId;
        ByteArrayOutputStream bouts = new ByteArrayOutputStream();
        DataOutputStream outs = new DataOutputStream(bouts);
        OrcResponse response = new OrcResponse();
        outs.writeInt(216858626);
        Orc orc = this;
        synchronized (orc) {
            transactionId = this.nextTransactionId++;
            this.transactionResponses.put(transactionId, response);
        }
        outs.writeInt(transactionId);
        outs.writeLong(System.nanoTime() / 1000L);
        outs.writeInt(commandId);
        if (payload != null) {
            outs.write(payload);
        }
        byte[] p = bouts.toByteArray();
        DatagramPacket packet = new DatagramPacket(p, p.length, this.orcAddr, 2378);
        long starttime = System.nanoTime();
        do {
            this.sock.send(packet);
            okay = response.waitForResponse((int)(2.0 * this.meanRTT * 1000.0));
            if (okay || !this.verbose) continue;
            System.out.println("Transaction timeout: " + transactionId + ", timeout=" + this.meanRTT);
        } while (!okay);
        long endtime = System.nanoTime();
        double rtt = (double)(endtime - starttime) / 1.0E9;
        double alpha = 0.995;
        this.meanRTT = alpha * this.meanRTT + (1.0 - alpha) * rtt;
        this.meanRTT = Math.min(Math.max(this.meanRTT, 0.002), 0.01);
        return response;
    }

    public OrcStatus getStatus() {
        while (true) {
            try {
                return new OrcStatus(this.doCommand(1, null));
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    public byte[] i2cTransaction(int addr, byte[] writebuf, int readlen) {
        return null;
    }

    public int[] spiTransaction(int slaveClk, int spo, int sph, int nbits, int[] writebuf) {
        slaveClk /= 1000;
        assert (nbits <= 16);
        assert (spo == 0 || spo == 1);
        assert (sph == 0 || sph == 1);
        assert (writebuf.length <= 16);
        ByteArrayOutputStream bouts = new ByteArrayOutputStream();
        bouts.write(slaveClk >> 8 & 0xFF);
        bouts.write(slaveClk & 0xFF);
        bouts.write(nbits | spo << 6 | sph << 7);
        bouts.write(writebuf.length);
        for (int i = 0; i < writebuf.length; ++i) {
            bouts.write(writebuf[i] >> 8 & 0xFF);
            bouts.write(writebuf[i] & 0xFF);
        }
        OrcResponse resp = this.doCommand(16384, bouts.toByteArray());
        assert (resp.responded);
        int[] rx = null;
        try {
            byte status = resp.ins.readByte();
            assert (status == 0);
            int nwords = resp.ins.readByte() & 0xFF;
            rx = new int[nwords];
            for (int i = 0; i < nwords; ++i) {
                rx[i] = resp.ins.readShort() & 0xFFFF;
            }
        }
        catch (IOException ex) {
            return null;
        }
        return rx;
    }

    public static void safesleep(int ms) {
        while (ms > 0) {
            long starttime = System.currentTimeMillis();
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            long endtime = System.currentTimeMillis();
            ms = (int)((long)ms - (endtime - starttime));
        }
    }

    class ReaderThread
    extends Thread {
        ReaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                byte[] packetBuffer = new byte[1600];
                DatagramPacket packet = new DatagramPacket(packetBuffer, packetBuffer.length);
                try {
                    OrcResponse sig;
                    Orc.this.sock.receive(packet);
                    DataInputStream ins = new DataInputStream(new ByteArrayInputStream(packetBuffer, 0, packet.getLength()));
                    int signature = ins.readInt();
                    if (signature != 216858625) {
                        System.out.println("bad signature");
                        continue;
                    }
                    int transId = ins.readInt();
                    long utime = ins.readLong();
                    int responseId = ins.readInt();
                    Orc orc = Orc.this;
                    synchronized (orc) {
                        sig = Orc.this.transactionResponses.remove(transId);
                    }
                    if (sig != null) {
                        sig.ins = ins;
                        sig.responseBuffer = packetBuffer;
                        sig.responseBufferOffset = 20;
                        sig.responseBufferLength = packet.getLength();
                        sig.utime = utime;
                        sig.responseId = responseId;
                        sig.gotResponse();
                        continue;
                    }
                    if (!Orc.this.verbose) continue;
                    System.out.println("Unexpected reply for transId: " + transId + " (last issued: " + (Orc.this.nextTransactionId - 1) + ")");
                    continue;
                }
                catch (IOException ex) {
                    System.out.println("Orc.ReaderThread Ex: " + ex);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex2) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

