/*
 * Decompiled with CFR 0.152.
 */
package orc;

import java.io.DataInputStream;
import java.io.IOException;
import orc.OrcResponse;

public class OrcStatus {
    public long utime;
    public int statusFlags;
    public int debugCharsWaiting;
    public int[] analogInput = new int[13];
    public int[] analogInputFiltered = new int[13];
    public int[] analogInputFilterAlpha = new int[13];
    public int simpleDigitalValues;
    public int simpleDigitalDirections;
    public boolean[] motorEnable = new boolean[3];
    public int[] motorPWMactual = new int[3];
    public int[] motorPWMgoal = new int[3];
    public int[] motorSlewRaw = new int[3];
    public double[] motorSlewSeconds = new double[3];
    public int[] qeiPosition = new int[2];
    public int[] qeiVelocity = new int[2];
    public int[] smartDigitalMode = new int[8];
    public int[] smartDigitalConfig = new int[8];
    public long[] gyroIntegrator = new long[3];
    public int[] gyroIntegratorCount = new int[3];

    static final int readU16(DataInputStream ins) throws IOException {
        return ins.readShort() & 0xFFFF;
    }

    static final int readS16(DataInputStream ins) throws IOException {
        return ins.readShort();
    }

    static final int readU8(DataInputStream ins) throws IOException {
        return ins.readByte() & 0xFF;
    }

    public OrcStatus(OrcResponse response) throws IOException {
        int i;
        DataInputStream ins = response.ins;
        this.utime = response.utime;
        this.statusFlags = ins.readInt();
        this.debugCharsWaiting = OrcStatus.readU16(ins);
        for (i = 0; i < 13; ++i) {
            this.analogInput[i] = OrcStatus.readU16(ins);
            this.analogInputFiltered[i] = OrcStatus.readU16(ins);
            this.analogInputFilterAlpha[i] = OrcStatus.readU16(ins);
        }
        this.simpleDigitalValues = ins.readInt();
        this.simpleDigitalDirections = ins.readInt();
        for (i = 0; i < 3; ++i) {
            this.motorEnable[i] = OrcStatus.readU8(ins) != 0;
            this.motorPWMactual[i] = OrcStatus.readS16(ins);
            this.motorPWMgoal[i] = OrcStatus.readS16(ins);
            this.motorSlewRaw[i] = OrcStatus.readU16(ins);
            this.motorSlewSeconds[i] = 510.0 / (double)this.motorSlewRaw[i] / 1000.0 * 128.0;
        }
        for (i = 0; i < 2; ++i) {
            this.qeiPosition[i] = ins.readInt();
            this.qeiVelocity[i] = ins.readInt();
        }
        for (i = 0; i < 8; ++i) {
            this.smartDigitalMode[i] = OrcStatus.readU8(ins);
            this.smartDigitalConfig[i] = ins.readInt();
        }
        for (i = 0; i < 3; ++i) {
            this.gyroIntegrator[i] = ins.readLong();
            this.gyroIntegratorCount[i] = ins.readInt();
        }
    }
}

