/*
 * Decompiled with CFR 0.152.
 */
package orc;

import orc.Orc;

public class Servo {
    Orc orc;
    int port;
    double pos0;
    double pos1;
    int usec0;
    int usec1;

    public Servo(Orc orc, int port, double pos0, int usec0, double pos1, int usec1) {
        this.orc = orc;
        this.port = port;
        this.pos0 = pos0;
        this.usec0 = usec0;
        this.pos1 = pos1;
        this.usec1 = usec1;
    }

    public void setPulseWidth(int usecs) {
        this.orc.doCommand(8192, new byte[]{(byte)this.port, (byte)(usecs >> 24 & 0xFF), (byte)(usecs >> 16 & 0xFF), (byte)(usecs >> 8 & 0xFF), (byte)(usecs >> 0 & 0xFF)});
    }

    public void setPosition(double pos) {
        if (pos < Math.min(this.pos0, this.pos1)) {
            pos = Math.min(this.pos0, this.pos1);
        }
        if (pos > Math.max(this.pos0, this.pos1)) {
            pos = Math.max(this.pos0, this.pos1);
        }
        this.setPulseWidth((int)((double)this.usec0 + (double)(this.usec1 - this.usec0) * (pos - this.pos0) / (this.pos1 - this.pos0)));
    }

    public static Servo makeMPIMX400(Orc orc, int port) {
        return new Servo(orc, port, 0.0, 600, Math.PI, 2500);
    }
}

