/*
 * Decompiled with CFR 0.152.
 */
package orc.camera;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import orc.util.NativeLibraryLoader;

public class Camera {
    public static final int WB_INDOOR = 0;
    public static final int WB_OUTDOOR = 1;
    public static final int WB_FLOURESCENT = 2;
    public static final int WB_MANUAL = 3;
    public static final int WB_AUTO = 4;
    protected int ref = -1;

    protected static native int camera_open(String var0);

    protected static native void camera_close(int var0);

    protected static native void camera_capture(int var0, int[] var1);

    protected static native void camera_set_capture_settings(int var0, int var1, int var2, int var3);

    protected static native int camera_get_width(int var0);

    protected static native int camera_get_height(int var0);

    protected static native int camera_get_fps(int var0);

    protected static native void camera_set_white_balance(int var0, int var1, int var2, int var3);

    protected static native int camera_get_white_balance(int var0, int var1);

    protected static native void camera_set_led(int var0, int var1, int var2);

    protected static native int camera_get_led_on(int var0);

    protected static native int camera_get_led_off(int var0);

    protected static native void camera_set_quality(int var0, int var1);

    protected static native int camera_get_quality(int var0);

    protected static native void camera_set_contour(int var0, int var1);

    protected static native int camera_get_contour(int var0);

    protected static native void camera_set_backlight(int var0, int var1);

    protected static native int camera_get_backlight(int var0);

    protected static native void camera_set_flicker(int var0, int var1);

    protected static native int camera_get_flicker(int var0);

    protected static native void camera_set_noisereduction(int var0, int var1);

    protected static native int camera_get_noisereduction(int var0);

    protected static native void camera_set_gain(int var0, int var1);

    protected static native int camera_get_gain(int var0);

    protected static native void camera_set_shutter(int var0, int var1);

    protected static native void rgb_to_hsv(int[] var0, int var1, int var2);

    protected static native void rgb_to_rgv(int[] var0, int var1, int var2);

    protected static native void channel_select(int[] var0, int var1, int var2, int var3);

    protected static native void camera_set_user(int var0);

    protected static native void camera_get_user(int var0);

    protected static native void camera_get_factory(int var0);

    public static Camera makeCamera() {
        String[] paths = new String[]{"/dev/video0", "/dev/video0", "/dev/video1"};
        int idx = 0;
        while (true) {
            try {
                Camera cam = new Camera(paths[idx]);
                return cam;
            }
            catch (Exception ex) {
                if (++idx != paths.length) continue;
                idx = 0;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public Camera(String devname) throws IOException {
        NativeLibraryLoader.requireNative(new String[]{"orc.jar", "camera.jar"}, "libcamera");
        this.ref = Camera.camera_open(devname);
        if (this.ref < 0) {
            throw new IOException("Unable to connect to camera " + devname);
        }
    }

    public synchronized void close() {
        Camera.camera_close(this.ref);
        this.ref = -1;
    }

    public synchronized BufferedImage createImage() {
        int width = Camera.camera_get_width(this.ref);
        int height = Camera.camera_get_height(this.ref);
        BufferedImage bi = new BufferedImage(width, height, 1);
        return bi;
    }

    public BufferedImage capture() {
        return this.capture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage capture(BufferedImage image) {
        Thread.yield();
        Camera camera = this;
        synchronized (camera) {
            if (image == null) {
                image = this.createImage();
            }
            if (image.getWidth(null) != this.getWidth() || image.getHeight(null) != this.getHeight()) {
                image = this.createImage();
            }
            DataBufferInt dbuf = (DataBufferInt)image.getRaster().getDataBuffer();
            int[] buf = dbuf.getData();
            Camera.camera_capture(this.ref, buf);
        }
        return image;
    }

    public synchronized void setCaptureSettings(int width, int height, int fps) {
        System.out.println("setting resolution " + width + "x" + height + "@" + fps);
        Camera.camera_set_capture_settings(this.ref, width, height, fps);
        System.out.println("done");
    }

    public synchronized int getWidth() {
        return Camera.camera_get_width(this.ref);
    }

    public synchronized int getHeight() {
        return Camera.camera_get_height(this.ref);
    }

    public synchronized int getFps() {
        return Camera.camera_get_fps(this.ref);
    }

    public synchronized void setWhiteBalanceMode(int mode) {
        Camera.camera_set_white_balance(this.ref, mode, 0, 0);
    }

    public synchronized int getWhiteBalanceMode() {
        return Camera.camera_get_white_balance(this.ref, 0);
    }

    public synchronized int getWhiteBalanceRed() {
        return Camera.camera_get_white_balance(this.ref, 1);
    }

    public synchronized int getWhiteBalanceBlue() {
        return Camera.camera_get_white_balance(this.ref, 2);
    }

    public synchronized void setWhiteBalanceManual(int red, int blue) {
        Camera.camera_set_white_balance(this.ref, 3, red, blue);
    }

    public synchronized void setLed(int onTime, int offTime) {
        Camera.camera_set_led(this.ref, onTime, offTime);
    }

    public synchronized int getLedOn() {
        return Camera.camera_get_led_on(this.ref);
    }

    public synchronized int getLedOff() {
        return Camera.camera_get_led_off(this.ref);
    }

    public synchronized void getFactory() {
        Camera.camera_get_factory(this.ref);
    }

    public synchronized void getUser() {
        Camera.camera_get_user(this.ref);
    }

    public synchronized void setUser() {
        Camera.camera_set_user(this.ref);
    }

    public synchronized void setQuality(int value) {
        Camera.camera_set_quality(this.ref, value);
    }

    public synchronized int getQuality() {
        return Camera.camera_get_quality(this.ref);
    }

    public synchronized void setContour(int value) {
        Camera.camera_set_contour(this.ref, value);
    }

    public synchronized int getContour() {
        return Camera.camera_get_quality(this.ref);
    }

    public synchronized void setBacklightCompensation(boolean value) {
        Camera.camera_set_backlight(this.ref, value ? 1 : 0);
    }

    public synchronized boolean getBacklightCompensation() {
        return Camera.camera_get_backlight(this.ref) != 0;
    }

    public synchronized void setFlicker(boolean value) {
        Camera.camera_set_flicker(this.ref, value ? 1 : 0);
    }

    public synchronized boolean getFlicker() {
        return Camera.camera_get_flicker(this.ref) != 0;
    }

    public synchronized void setNoiseReduction(int value) {
        Camera.camera_set_noisereduction(this.ref, value);
    }

    public synchronized int getNoiseReduction() {
        return Camera.camera_get_noisereduction(this.ref);
    }

    public synchronized void setGain(int value) {
        Camera.camera_set_gain(this.ref, value);
    }

    public synchronized int getGain() {
        return Camera.camera_get_gain(this.ref);
    }

    public synchronized void setShutter(int value) {
        Camera.camera_set_shutter(this.ref, value);
    }
}

