/*
 * Decompiled with CFR 0.152.
 */
package orc.camera;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import orc.camera.Camera;
import orc.camera.ImageUtil;
import orc.util.JImage;

public class CameraViewer {
    JFrame frame;
    Camera cam;
    JImage jimage;
    JButton setUserButton = new JButton("Set User");
    JButton getUserButton = new JButton("Get User");
    JButton getFactoryButton = new JButton("Restore Factory");
    JCheckBox antiFlickerCheckBox = new JCheckBox();
    JCheckBox backlightCompCheckBox = new JCheckBox();
    JSlider noiseReductionSlider = new JSlider(0, 0, 3, 0);
    JSlider qualitySlider = new JSlider(0, 0, 3, 0);
    JCheckBox autoGainCheckBox = new JCheckBox();
    JSlider gainSlider = new JSlider(0, 0, 65535, 0);
    JCheckBox autoShutterCheckBox = new JCheckBox();
    JSlider shutterSlider = new JSlider(0, 0, 65535, 65535);
    JCheckBox autoContourCheckBox = new JCheckBox();
    JSlider contourSlider = new JSlider(0, 0, 65535, 0);
    JComboBox wbModeBox = new JComboBox<Object>(new Object[]{"Indoor", "Outdoor", "Flourescent", "Manual", "Auto"});
    JSlider wbRedSlider = new JSlider(0, 0, 65535, 0);
    JSlider wbBlueSlider = new JSlider(0, 0, 65535, 0);
    JSlider ledOnSlider = new JSlider(0, 0, 2500, 0);
    JSlider ledOffSlider = new JSlider(0, 0, 2500, 0);
    JComboBox resolutionBox = new JComboBox<Object>(new Object[]{new CaptureSettings(128, 96, 15), new CaptureSettings(160, 120, 5), new CaptureSettings(160, 120, 15), new CaptureSettings(160, 120, 30), new CaptureSettings(176, 144, 30), new CaptureSettings(320, 240, 5), new CaptureSettings(320, 240, 15), new CaptureSettings(320, 240, 30), new CaptureSettings(352, 288, 30), new CaptureSettings(640, 480, 5), new CaptureSettings(640, 480, 10), new CaptureSettings(640, 480, 15)});
    JComboBox colorspaceBox = new JComboBox<Object>(new Object[]{"RGB", "HSV"});
    JComboBox channelsBox = new JComboBox<Object>(new Object[]{"All channels", "Channel 0", "Channel 1", "Channel 2", "Channel 3"});
    JCheckBox scaleImageCheckBox = new JCheckBox();
    JLabel frameRateLabel = new JLabel("FPS: 0");
    BufferedImage camimage = null;
    JButton snapshotButton = new JButton("Write Image");
    JLabel colorSampleLabel = new JLabel("");
    Point colorSamplePoint = new Point(0, 0);

    public static void main(String[] args) {
        boolean forcequit = true;
        try {
            CameraViewer app = new CameraViewer("/dev/video");
            app.run();
        }
        catch (Exception ex) {
            System.out.println("Uncaught exception " + ex);
        }
        if (forcequit) {
            System.exit(0);
        }
    }

    public synchronized void updateImage() {
        this.camimage = this.cam.capture(null);
        switch (this.colorspaceBox.getSelectedIndex()) {
            case 0: {
                break;
            }
            case 1: {
                ImageUtil.rgbToHsv(this.camimage);
            }
        }
        if (this.channelsBox.getSelectedIndex() != 0) {
            ImageUtil.channelSelect(this.camimage, this.channelsBox.getSelectedIndex() - 1);
        }
        this.jimage.setImage(this.camimage);
        this.updateColorSample();
    }

    public void updateColorSample() {
        int rgb;
        if (this.colorSamplePoint == null) {
            this.colorSampleLabel.setText("(no sample)");
            return;
        }
        try {
            rgb = this.camimage.getRGB((int)this.colorSamplePoint.getX(), (int)this.colorSamplePoint.getY());
        }
        catch (Exception ex) {
            this.colorSampleLabel.setText("(no sample)");
            return;
        }
        int b = rgb & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int r = rgb >> 16 & 0xFF;
        this.colorSampleLabel.setText(String.format("(%4d,%4d ): %08X %02X %02X %02X", (int)this.colorSamplePoint.getX(), (int)this.colorSamplePoint.getY(), rgb, r, g, b));
    }

    public void run() throws Exception {
        this.updateImage();
        this.frame.setSize(this.frame.getPreferredSize());
        this.frame.setVisible(true);
        int nframes = 0;
        long starttime = System.currentTimeMillis();
        while (true) {
            this.updateImage();
            ++nframes;
            long thistime = System.currentTimeMillis();
            if (thistime - starttime <= 1000L) continue;
            double framerate = (double)nframes / ((double)(thistime - starttime) / 1000.0);
            this.frameRateLabel.setText(String.format("FPS: %5.2f", framerate));
            nframes = 0;
            starttime = thistime;
        }
    }

    public CameraViewer(String device) {
        this.frame = new JFrame("CameraViewer");
        BorderLayout bl = new BorderLayout();
        bl.setHgap(5);
        this.frame.getContentPane().setLayout(bl);
        try {
            this.cam = new Camera(device);
        }
        catch (IOException ex) {
            System.out.println("Couldn't open camera:" + ex);
            return;
        }
        this.jimage = new JImage(this.cam.getWidth(), this.cam.getHeight());
        this.jimage.setScale(true);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)new JLabel("Resolution"), gbc);
        gbc.gridx = 1;
        panel.add((Component)this.resolutionBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)new JLabel("Anti-Flicker"), gbc);
        gbc.gridx = 1;
        panel.add((Component)this.antiFlickerCheckBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)new JLabel("Noise Reduction"), gbc);
        gbc.gridx = 1;
        panel.add((Component)this.noiseReductionSlider, gbc);
        this.noiseReductionSlider.setSnapToTicks(true);
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)new JLabel("Compression"), gbc);
        gbc.gridx = 1;
        panel.add((Component)this.qualitySlider, gbc);
        this.qualitySlider.setSnapToTicks(true);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        panel.add((Component)new JSeparator(0), gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)new JLabel("Auto Gain"), gbc);
        gbc.gridx = 1;
        panel.add((Component)this.autoGainCheckBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)new JLabel("Backlight Comp"), gbc);
        gbc.gridx = 1;
        panel.add((Component)this.backlightCompCheckBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)new JLabel("Manual Gain"), gbc);
        gbc.gridx = 1;
        panel.add((Component)this.gainSlider, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)new JLabel("Auto Shutter"), gbc);
        gbc.gridx = 1;
        panel.add((Component)this.autoShutterCheckBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)new JLabel("Manual Shutter"), gbc);
        gbc.gridx = 1;
        panel.add((Component)this.shutterSlider, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        panel.add((Component)new JSeparator(0), gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)new JLabel("Auto Contour"), gbc);
        gbc.gridx = 1;
        panel.add((Component)this.autoContourCheckBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)new JLabel("Manual Contour"), gbc);
        gbc.gridx = 1;
        panel.add((Component)this.contourSlider, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        panel.add((Component)new JSeparator(0), gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)new JLabel("WhiteBalance Mode"), gbc);
        gbc.gridx = 1;
        panel.add((Component)this.wbModeBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)new JLabel("Manual WB Red"), gbc);
        gbc.gridx = 1;
        panel.add((Component)this.wbRedSlider, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)new JLabel("Manual WB Blue"), gbc);
        gbc.gridx = 1;
        panel.add((Component)this.wbBlueSlider, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        panel.add((Component)new JSeparator(0), gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)new JLabel("LED on time"), gbc);
        gbc.gridx = 1;
        panel.add((Component)this.ledOnSlider, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)new JLabel("LED off time"), gbc);
        gbc.gridx = 1;
        panel.add((Component)this.ledOffSlider, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        panel.add((Component)new JSeparator(0), gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)this.setUserButton, gbc);
        ++gbc.gridx;
        panel.add((Component)this.getUserButton, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)this.getFactoryButton, gbc);
        this.frame.getContentPane().add((Component)panel, "East");
        JPanel ippanel = new JPanel(new FlowLayout());
        ippanel.add(this.frameRateLabel);
        ippanel.add(this.colorspaceBox);
        ippanel.add(this.channelsBox);
        ippanel.add(new JLabel("Scale"));
        ippanel.add(this.scaleImageCheckBox);
        this.scaleImageCheckBox.setSelected(true);
        this.colorSampleLabel.setFont(new Font("Monospaced", 0, 12));
        JPanel buttonpanel = new JPanel(new BorderLayout());
        buttonpanel.add((Component)this.colorSampleLabel, "West");
        buttonpanel.add((Component)this.snapshotButton, "East");
        JPanel picpanel = new JPanel(new BorderLayout());
        picpanel.add((Component)this.jimage, "Center");
        picpanel.add((Component)ippanel, "North");
        picpanel.add((Component)buttonpanel, "South");
        this.frame.getContentPane().add((Component)picpanel, "Center");
        this.updateAllControls();
        this.antiFlickerCheckBox.addActionListener(new FlickerActionListener());
        this.backlightCompCheckBox.addActionListener(new BacklightActionListener());
        this.noiseReductionSlider.addChangeListener(new NoiseActionListener());
        this.qualitySlider.addChangeListener(new QualityActionListener());
        this.autoGainCheckBox.addActionListener(new GainActionListener());
        this.gainSlider.addChangeListener(new GainChangeListener());
        this.autoShutterCheckBox.addActionListener(new ShutterActionListener());
        this.shutterSlider.addChangeListener(new ShutterChangeListener());
        this.autoContourCheckBox.addActionListener(new ContourActionListener());
        this.contourSlider.addChangeListener(new ContourActionListener());
        this.wbModeBox.addActionListener(new WhiteBalanceActionListener());
        this.wbRedSlider.addChangeListener(new WhiteBalanceActionListener());
        this.wbBlueSlider.addChangeListener(new WhiteBalanceActionListener());
        this.ledOnSlider.addChangeListener(new LEDActionListener());
        this.ledOffSlider.addChangeListener(new LEDActionListener());
        this.resolutionBox.addActionListener(new ResolutionListener());
        this.scaleImageCheckBox.addActionListener(new ScaleActionListener());
        this.snapshotButton.addActionListener(new SnapshotListener());
        this.setUserButton.addActionListener(new SetUserListener());
        this.getUserButton.addActionListener(new GetUserListener());
        this.getFactoryButton.addActionListener(new GetFactoryListener());
        this.jimage.addMouseMotionListener(new MouseListener());
        PollSettingsThread pst = new PollSettingsThread();
        pst.start();
        this.frame.addWindowListener(new MyWindowListener());
    }

    public void updateAllControls() {
        int v;
        int width = this.cam.getWidth();
        int height = this.cam.getHeight();
        int fps = this.cam.getFps();
        int bestidx = 0;
        boolean bestscore = false;
        for (v = 0; v < this.resolutionBox.getItemCount(); ++v) {
            CaptureSettings cs = (CaptureSettings)this.resolutionBox.getItemAt(v);
            if (cs.width == width && cs.height == height && cs.fps == fps) {
                bestidx = v;
                break;
            }
            if (cs.width != width || cs.height != height) continue;
            bestidx = v;
        }
        this.resolutionBox.setSelectedIndex(bestidx);
        v = this.cam.getGain();
        this.autoGainCheckBox.setSelected(v < 0);
        v = this.cam.getContour();
        this.autoContourCheckBox.setSelected(v == -1);
        try {
            this.wbModeBox.setSelectedIndex(this.cam.getWhiteBalanceMode());
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.wbRedSlider.setValue(this.cam.getWhiteBalanceRed());
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.wbBlueSlider.setValue(this.cam.getWhiteBalanceBlue());
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.ledOnSlider.setValue(this.cam.getLedOn());
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.ledOffSlider.setValue(this.cam.getLedOff());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.antiFlickerCheckBox.setSelected(this.cam.getFlicker());
        this.backlightCompCheckBox.setSelected(this.cam.getBacklightCompensation());
        this.noiseReductionSlider.setValue(this.cam.getNoiseReduction());
        this.qualitySlider.setValue(this.cam.getQuality());
        this.updateControls();
    }

    public void updateControls() {
        int v = this.cam.getGain();
        if (this.autoGainCheckBox.isSelected()) {
            this.gainSlider.setValue(v >= 0 ? v : -v);
        }
        v = this.cam.getContour();
        if (this.autoContourCheckBox.isSelected()) {
            this.contourSlider.setValue(v);
        }
    }

    class MyWindowListener
    extends WindowAdapter {
        MyWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }

    class PollSettingsThread
    extends Thread {
        PollSettingsThread() {
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                CameraViewer.this.updateControls();
            }
        }
    }

    class MouseListener
    extends MouseMotionAdapter {
        MouseListener() {
        }

        public void mouseMoved(MouseEvent e) {
            CameraViewer.this.colorSamplePoint = CameraViewer.this.jimage.componentToImage(e.getPoint());
            CameraViewer.this.updateColorSample();
        }
    }

    class SnapshotListener
    implements ActionListener {
        SnapshotListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Calendar cal = Calendar.getInstance();
            int year = cal.get(1);
            int month = cal.get(2);
            int day = cal.get(5);
            int hour = cal.get(10);
            int min = cal.get(12);
            int sec = cal.get(13);
            int ms = cal.get(14);
            BufferedImage im = CameraViewer.this.camimage;
            String path = String.format("snap%04d%02d%02d_%02d%02d%02d.%03d.png", year, month, day, hour, min, sec, ms);
            try {
                ImageIO.write((RenderedImage)im, "png", new File(path));
                System.out.println("Image written to: " + path);
            }
            catch (IOException ex) {
                System.out.println("Couldn't write image." + ex);
            }
        }
    }

    class ResolutionListener
    implements ActionListener {
        ResolutionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int v = CameraViewer.this.resolutionBox.getSelectedIndex();
            CaptureSettings cs = (CaptureSettings)CameraViewer.this.resolutionBox.getItemAt(v);
            CameraViewer.this.cam.setCaptureSettings(cs.width, cs.height, cs.fps);
        }
    }

    class LEDActionListener
    implements ActionListener,
    ChangeListener {
        LEDActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int v1 = CameraViewer.this.ledOnSlider.getValue();
            int v2 = CameraViewer.this.ledOffSlider.getValue();
            CameraViewer.this.cam.setLed(v1, v2);
        }

        public void stateChanged(ChangeEvent e) {
            this.actionPerformed(null);
        }
    }

    class GetFactoryListener
    implements ActionListener {
        GetFactoryListener() {
        }

        public void actionPerformed(ActionEvent e) {
            CameraViewer.this.cam.getFactory();
            CameraViewer.this.updateAllControls();
        }
    }

    class GetUserListener
    implements ActionListener {
        GetUserListener() {
        }

        public void actionPerformed(ActionEvent e) {
            CameraViewer.this.cam.getUser();
            CameraViewer.this.updateAllControls();
        }
    }

    class SetUserListener
    implements ActionListener {
        SetUserListener() {
        }

        public void actionPerformed(ActionEvent e) {
            CameraViewer.this.cam.setUser();
            CameraViewer.this.updateAllControls();
        }
    }

    class WhiteBalanceActionListener
    implements ActionListener,
    ChangeListener {
        WhiteBalanceActionListener() {
        }

        public void stateChanged(ChangeEvent e) {
            int mode = CameraViewer.this.wbModeBox.getSelectedIndex();
            if (mode != 3) {
                CameraViewer.this.cam.setWhiteBalanceMode(mode);
            } else {
                CameraViewer.this.cam.setWhiteBalanceManual(CameraViewer.this.wbRedSlider.getValue(), CameraViewer.this.wbBlueSlider.getValue());
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.stateChanged(null);
        }
    }

    class ContourActionListener
    implements ActionListener,
    ChangeListener {
        ContourActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int v = CameraViewer.this.contourSlider.getValue();
            if (CameraViewer.this.autoContourCheckBox.isSelected()) {
                v = -1;
            }
            CameraViewer.this.cam.setContour(v);
        }

        public void stateChanged(ChangeEvent e) {
            this.actionPerformed(null);
        }
    }

    class ShutterChangeListener
    implements ChangeListener {
        ShutterChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            int v = CameraViewer.this.shutterSlider.getValue();
            if (!CameraViewer.this.autoShutterCheckBox.isSelected()) {
                CameraViewer.this.cam.setShutter(v);
            }
        }
    }

    class ShutterActionListener
    implements ActionListener {
        ShutterActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (CameraViewer.this.autoShutterCheckBox.isSelected()) {
                CameraViewer.this.cam.setShutter(-1);
            } else {
                CameraViewer.this.cam.setShutter(CameraViewer.this.shutterSlider.getValue());
            }
        }
    }

    class GainChangeListener
    implements ChangeListener {
        GainChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            int v = CameraViewer.this.gainSlider.getValue();
            if (!CameraViewer.this.autoGainCheckBox.isSelected()) {
                CameraViewer.this.cam.setGain(v);
            }
        }
    }

    class GainActionListener
    implements ActionListener {
        GainActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (CameraViewer.this.autoGainCheckBox.isSelected()) {
                CameraViewer.this.cam.setGain(-1);
            } else {
                CameraViewer.this.cam.setGain(CameraViewer.this.gainSlider.getValue());
            }
        }
    }

    class QualityActionListener
    implements ActionListener,
    ChangeListener {
        QualityActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int v = CameraViewer.this.qualitySlider.getValue();
            CameraViewer.this.cam.setQuality(v);
        }

        public void stateChanged(ChangeEvent e) {
            this.actionPerformed(null);
        }
    }

    class NoiseActionListener
    implements ActionListener,
    ChangeListener {
        NoiseActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int v = CameraViewer.this.noiseReductionSlider.getValue();
            CameraViewer.this.cam.setNoiseReduction(v);
        }

        public void stateChanged(ChangeEvent e) {
            this.actionPerformed(null);
        }
    }

    class BacklightActionListener
    implements ActionListener {
        BacklightActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean v = CameraViewer.this.backlightCompCheckBox.isSelected();
            CameraViewer.this.cam.setBacklightCompensation(v);
        }
    }

    class FlickerActionListener
    implements ActionListener {
        FlickerActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean v = CameraViewer.this.antiFlickerCheckBox.isSelected();
            CameraViewer.this.cam.setFlicker(v);
        }
    }

    class ScaleActionListener
    implements ActionListener {
        ScaleActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean v = CameraViewer.this.scaleImageCheckBox.isSelected();
            CameraViewer.this.jimage.setScale(v);
        }
    }

    class CaptureSettings {
        int width;
        int height;
        int fps;

        public CaptureSettings(int width, int height, int fps) {
            this.width = width;
            this.height = height;
            this.fps = fps;
        }

        public String toString() {
            return "" + this.width + "x" + this.height + "@" + this.fps;
        }
    }
}

