/*
 * Decompiled with CFR 0.152.
 */
package orc.examples;

import orc.Motor;
import orc.Orc;
import orc.util.GamePad;

public class GamePadDrive {
    public static void main(String[] args) {
        GamePad gp = new GamePad();
        Orc orc = Orc.makeOrc();
        Motor leftMotor = new Motor(orc, 0, false);
        Motor rightMotor = new Motor(orc, 1, true);
        System.out.println("Hit any gamepad button to begin.");
        gp.waitForAnyButtonPress();
        System.out.printf("%15s %15s %15s %15s\n", "left", "right", "left current", "right current");
        while (true) {
            double left = 0.0;
            double right = 0.0;
            double fwd = -gp.getAxis(3);
            double lr = gp.getAxis(2);
            left = fwd - lr;
            right = fwd + lr;
            double max = Math.max(Math.abs(left), Math.abs(right));
            if (max > 1.0) {
                left /= max;
                right /= max;
            }
            System.out.printf("%15f %15f %15f %15f\r", left, right, leftMotor.getCurrent(), rightMotor.getCurrent());
            leftMotor.setPWM(left);
            rightMotor.setPWM(right);
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException ex) {
            }
        }
    }
}

