/*
 * Decompiled with CFR 0.152.
 */
package orc.spy;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import orc.Motor;
import orc.Orc;
import orc.OrcStatus;
import orc.Servo;
import orc.spy.SmallSlider;
import orc.spy.WeightedGridLayout;

public class Spy {
    JFrame jf;
    JDesktopPane jdp = new JDesktopPane();
    TextPanelWidget basicDisplay;
    TextPanelWidget analogDisplay;
    TextPanelWidget qeiDisplay;
    TextPanelWidget digDisplay;
    MotorPanel[] motorPanels;
    ServoPanel[] servoPanels;
    Orc orc = Orc.makeOrc();
    int xpos = 0;
    int ypos = 0;
    boolean firstStatus = true;

    public static void main(String[] args) {
        new Spy();
    }

    public Spy() {
        this.jf = new JFrame("OrcSpy");
        this.jf.setLayout(new BorderLayout());
        this.jf.add((Component)this.jdp, "Center");
        this.basicDisplay = new TextPanelWidget(new String[]{"Parameter", "Value"}, new String[][]{{"uorc time", "0"}}, new double[]{0.4, 0.6});
        this.analogDisplay = new TextPanelWidget(new String[]{"Port", "Raw value", "Value", "LPF Value"}, new String[][]{{"0", "0", "0", "0"}, {"1", "0", "0", "0"}, {"2", "0", "0", "0"}, {"3", "0", "0", "0"}, {"4", "0", "0", "0"}, {"5", "0", "0", "0"}, {"6", "0", "0", "0"}, {"7", "0", "0", "0"}, {" 8 (mot0)", "0", "0", "0"}, {" 9 (mot1)", "0", "0", "0"}, {"10 (mot2)", "0", "0", "0"}, {"11 (vbat)", "0", "0", "0"}, {"12 (temp)", "0", "0", "0"}}, new double[]{0.3, 0.5, 0.5, 0.5});
        this.digDisplay = new TextPanelWidget(new String[]{"Port", "Mode", "Value"}, new String[][]{{"0", "--", "0"}, {"1", "--", "0"}, {"2", "--", "0"}, {"3", "--", "0"}, {"4", "--", "0"}, {"5", "--", "0"}, {"6", "--", "0"}, {"7", "--", "0"}, {"8  (mot0 fail)", "--", "0"}, {"9  (mot0 en)  ", "--", "0"}, {"10 (mot1 fail)", "--", "0"}, {"11 (mot1 en)  ", "--", "0"}, {"12 (mot2 fail)", "--", "0"}, {"13 (mot2 en)  ", "--", "0"}, {"14 (estop)    ", "--", "0"}, {"15 (button0)  ", "--", "0"}}, new double[]{0.3, 0.5, 0.5});
        this.qeiDisplay = new TextPanelWidget(new String[]{"Port", "Position", "Velocity"}, new String[][]{{"0", "0", "0"}, {"1", "0", "0"}}, new double[]{0.3, 0.5, 0.5});
        JPanel motDisplay = new JPanel();
        WeightedGridLayout motorWGL = new WeightedGridLayout(new double[]{0.0, 0.0, 0.8, 0.2});
        motorWGL.setDefaultRowWeight(1.0);
        motorWGL.setRowWeight(0, 0.0);
        motDisplay.setLayout(motorWGL);
        motDisplay.add(new JLabel("# "));
        motDisplay.add(new JLabel("En "));
        motDisplay.add(new JLabel("PWM "));
        motDisplay.add(new JLabel("Slew"));
        this.motorPanels = new MotorPanel[3];
        for (int i = 0; i < this.motorPanels.length; ++i) {
            this.motorPanels[i] = new MotorPanel(motDisplay, i);
        }
        JPanel servoDisplay = new JPanel();
        servoDisplay.setLayout(new GridLayout(8, 1));
        this.servoPanels = new ServoPanel[8];
        for (int i = 0; i < this.servoPanels.length; ++i) {
            this.servoPanels[i] = new ServoPanel(i);
            JPanel jp = new JPanel();
            jp.setLayout(new BorderLayout());
            jp.add((Component)new JLabel(" " + i), "West");
            jp.add((Component)this.servoPanels[i], "Center");
            servoDisplay.add(jp);
        }
        this.jf.setSize(906, 550);
        this.jf.setVisible(true);
        this.makeInternalFrame("Basic Properties", this.basicDisplay, 300, 120);
        this.makeInternalFrame("Analog Input", this.analogDisplay, 300, 285);
        this.makeInternalFrame("Quadrature Decoders", this.qeiDisplay, 300, 120);
        this.makeInternalFrame("Motors", motDisplay, 300, 200);
        this.makeInternalFrame("Servos", servoDisplay, 300, 300);
        this.makeInternalFrame("DigitalIO", this.digDisplay, 300, 330);
        new StatusPollThread().start();
        this.jf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    void makeInternalFrame(String name, JComponent jc, int width, int height) {
        JInternalFrame jif = new JInternalFrame(name, true, true, true, true);
        jif.setLayout(new BorderLayout());
        jif.add((Component)jc, "Center");
        if (this.ypos + height >= this.jf.getHeight()) {
            this.ypos = 0;
            this.xpos += width;
        }
        jif.reshape(this.xpos, this.ypos, width, height);
        this.ypos += height;
        jif.setVisible(true);
        this.jdp.add(jif);
        this.jdp.setBackground(Color.blue);
    }

    public void orcStatus(Orc orc, OrcStatus status) {
        int i;
        if (status.utime < 2000000L) {
            this.firstStatus = true;
        }
        for (i = 0; i < 2; ++i) {
            this.qeiDisplay.values[i][1] = String.format("%6d", status.qeiPosition[i]);
            this.qeiDisplay.values[i][2] = String.format("%6d", status.qeiVelocity[i]);
        }
        this.basicDisplay.values[0][1] = String.format("%.6f", (double)status.utime / 1000000.0);
        for (i = 0; i < 13; ++i) {
            double voltage;
            this.analogDisplay.values[i][1] = String.format("%04X", status.analogInput[i]);
            if (i < 8) {
                voltage = (double)status.analogInput[i] / 65535.0 * 3.3;
                this.analogDisplay.values[i][2] = String.format("%8.3f V  ", voltage);
                voltage = (double)status.analogInputFiltered[i] / 65535.0 * 3.3;
                this.analogDisplay.values[i][3] = String.format("%8.3f V  ", voltage);
                continue;
            }
            if (i >= 8 && i <= 10) {
                voltage = (double)status.analogInput[i] / 65535.0 * 3.0;
                double current = voltage * 375.0 / 200.0 * 1000.0;
                this.analogDisplay.values[i][2] = String.format("%8.0f mA ", current);
                voltage = (double)status.analogInputFiltered[i] / 65535.0 * 3.0;
                current = voltage * 375.0 / 200.0 * 1000.0;
                this.analogDisplay.values[i][3] = String.format("%8.0f mA ", current);
                continue;
            }
            if (i == 11) {
                voltage = (double)status.analogInput[i] / 65535.0 * 3.0;
                double batvoltage = voltage * 10.1;
                this.analogDisplay.values[i][2] = String.format("%8.2f V  ", batvoltage);
                voltage = (double)status.analogInputFiltered[i] / 65535.0 * 3.0;
                batvoltage = voltage * 10.1;
                this.analogDisplay.values[i][3] = String.format("%8.2f V  ", batvoltage);
                continue;
            }
            voltage = (double)status.analogInput[i] / 65535.0 * 3.0;
            double temp = -(voltage - 2.7) * 75.0 - 55.0;
            this.analogDisplay.values[i][2] = String.format("%8.2f degC", temp);
            voltage = (double)status.analogInputFiltered[i] / 65535.0 * 3.0;
            temp = -(voltage - 2.7) * 75.0 - 55.0;
            this.analogDisplay.values[i][3] = String.format("%8.2f degC", temp);
        }
        System.out.printf("%08x\n", status.simpleDigitalValues);
        for (i = 0; i < 16; ++i) {
            int val = status.simpleDigitalValues >> i & 1;
            this.digDisplay.values[i][2] = "" + val;
        }
        for (i = 0; i < 3; ++i) {
            this.motorPanels[i].pwmslider.setActualValue(status.motorPWMactual[i]);
            this.motorPanels[i].slewslider.setActualValue((int)(status.motorSlewSeconds[i] / this.motorPanels[i].slewslider.formatScale));
            this.motorPanels[i].enabledCheckbox.setSelected(status.motorEnable[i]);
            if (!this.firstStatus) continue;
            this.motorPanels[i].pwmslider.setGoalValue(status.motorPWMactual[i]);
            this.motorPanels[i].slewslider.setGoalValue((int)(status.motorSlewSeconds[i] / this.motorPanels[i].slewslider.formatScale));
        }
        this.firstStatus = false;
        this.digDisplay.repaint();
        this.qeiDisplay.repaint();
        this.basicDisplay.repaint();
        this.analogDisplay.repaint();
    }

    class TextPanelWidget
    extends JPanel {
        String panelName;
        String[] columnNames;
        String[][] values;
        double[] columnWidthWeight;

        public TextPanelWidget(String[] columnNames, String[][] values, double[] columnWidthWeight) {
            this.columnNames = columnNames;
            this.columnWidthWeight = columnWidthWeight;
            this.values = values;
        }

        int getStringWidth(Graphics g, String s) {
            FontMetrics fm = g.getFontMetrics(g.getFont());
            return fm.stringWidth(s);
        }

        int getStringHeight(Graphics g, String s) {
            FontMetrics fm = g.getFontMetrics(g.getFont());
            return fm.getMaxAscent();
        }

        public Dimension getPreferredSize() {
            return new Dimension(100, 100);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return new Dimension(1000, 1000);
        }

        public void paint(Graphics _g) {
            int i;
            Graphics2D g = (Graphics2D)_g;
            int width = this.getWidth();
            int height = this.getHeight();
            Font fb = new Font("Monospaced", 1, 12);
            Font fp = new Font("Monospaced", 0, 12);
            g.setFont(fb);
            int textHeight = this.getStringHeight(g, "");
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
            g.setColor(Color.black);
            g.drawRect(0, 0, width - 1, height - 1);
            double totalColumnWidthWeight = 0.0;
            for (int i2 = 0; i2 < this.columnWidthWeight.length; ++i2) {
                totalColumnWidthWeight += this.columnWidthWeight[i2];
            }
            int[] columnPos = new int[this.columnWidthWeight.length];
            int[] columnWidth = new int[this.columnWidthWeight.length];
            for (i = 0; i < columnWidth.length; ++i) {
                columnWidth[i] = (int)((double)width * this.columnWidthWeight[i] / totalColumnWidthWeight);
            }
            for (i = 1; i < columnWidth.length; ++i) {
                columnPos[i] = columnPos[i - 1] + columnWidth[i - 1];
            }
            g.setColor(Color.black);
            for (i = 0; i < this.columnNames.length; ++i) {
                String s = this.columnNames[i];
                g.drawString(s, columnPos[i] + columnWidth[i] / 2 - this.getStringWidth(g, s) / 2, textHeight * 3 / 2);
            }
            g.setFont(fp);
            for (i = 0; i < this.values.length; ++i) {
                for (int j = 0; j < this.columnNames.length; ++j) {
                    String s = this.values[i][j];
                    if (s == null) {
                        s = "";
                    }
                    g.drawString(s, columnPos[j] + columnWidth[j] / 2 - this.getStringWidth(g, s) / 2, textHeight * (3 + i));
                }
            }
        }
    }

    class MotorPanel
    implements SmallSlider.Listener {
        SmallSlider pwmslider = new SmallSlider(-255, 255, 0, 0, true);
        SmallSlider slewslider = new SmallSlider(0, 65535, 0, 0, true);
        JCheckBox enabledCheckbox = new JCheckBox();
        int port;
        Motor motor;

        MotorPanel(JPanel jp, int port) {
            this.motor = new Motor(Spy.this.orc, port, false);
            this.pwmslider.formatScale = 0.39215686274509803;
            this.pwmslider.formatString = "%.0f %%";
            this.slewslider.formatString = "%.3fs";
            this.slewslider.formatScale = 4.5777065690089265E-5;
            jp.add(new JLabel(" " + port));
            jp.add(this.enabledCheckbox);
            jp.add(this.pwmslider);
            jp.add(this.slewslider);
            this.pwmslider.addListener(this);
            this.slewslider.addListener(this);
            this.enabledCheckbox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MotorPanel.this.enabledClicked();
                }
            });
        }

        public void goalValueChanged(SmallSlider slider, int goal) {
            if (slider == this.pwmslider) {
                this.motor.setPWM((double)goal / 255.0);
            }
            if (slider == this.slewslider) {
                this.motor.setSlewSeconds((double)goal * this.slewslider.formatScale);
            }
        }

        void enabledClicked() {
            if (this.enabledCheckbox.isSelected()) {
                this.motor.setPWM((double)this.pwmslider.getGoalValue() / 255.0);
            } else {
                this.motor.idle();
            }
        }
    }

    class ServoPanel
    extends JPanel
    implements SmallSlider.Listener {
        SmallSlider slider = new SmallSlider(250, 3750, 1500, 1500, true);
        Servo servo;

        ServoPanel(int port) {
            this.slider.formatScale = 1.0;
            this.slider.formatString = "%.0f us";
            this.servo = new Servo(Spy.this.orc, port, 0.0, 0, 0.0, 0);
            this.setLayout(new BorderLayout());
            this.add((Component)this.slider, "Center");
            this.slider.addListener(this);
        }

        public void goalValueChanged(SmallSlider slider, int goal) {
            this.servo.setPulseWidth(goal);
        }
    }

    class StatusPollThread
    extends Thread {
        StatusPollThread() {
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        OrcStatus status = Spy.this.orc.getStatus();
                        Spy.this.orcStatus(Spy.this.orc, status);
                        Thread.sleep(100L);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Spy.StatusPollThread ex: " + ex);
                    continue;
                }
                break;
            }
        }
    }
}

