/*
 * Decompiled with CFR 0.152.
 */
package orc.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class JImage
extends JComponent {
    public static final long serialVersionUID = 1001L;
    Image i;
    boolean scale = false;

    public JImage() {
        this.i = null;
    }

    public JImage(int width, int height) {
        this.i = new BufferedImage(width, height, 10);
    }

    public void setImage(Image i) {
        this.i = i;
        this.invalidate();
        this.repaint();
    }

    public Dimension getMinimumSize() {
        if (this.i == null) {
            return new Dimension(2, 2);
        }
        return new Dimension(this.i.getWidth(null), this.i.getHeight(null));
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        return this.getMinimumSize();
    }

    public Point componentToImage(Point p) {
        int imy;
        int imx;
        int height = this.getHeight();
        int width = this.getWidth();
        int cy = height / 2;
        int cx = width / 2;
        int imheight = this.i.getHeight(null);
        int imwidth = this.i.getWidth(null);
        if (this.scale) {
            int scaleheight;
            int scalewidth;
            int imageratio = imwidth / imheight;
            int displayratio = width / height;
            if (imageratio >= displayratio) {
                scalewidth = width;
                scaleheight = width * imheight / imwidth;
            } else {
                scaleheight = height;
                scalewidth = height * imwidth / imheight;
            }
            imx = imwidth * (p.x - cx) / scalewidth + imwidth / 2;
            imy = imheight * (p.y - cy) / scaleheight + imheight / 2;
        } else {
            imx = p.x - cx + imwidth / 2;
            imy = p.y - cy + imheight / 2;
        }
        if (imx < 0 || imy < 0 || imx >= imwidth || imy >= imheight) {
            return null;
        }
        return new Point(imx, imy);
    }

    public synchronized void paint(Graphics gin) {
        Graphics2D g = (Graphics2D)gin;
        if (this.i == null) {
            return;
        }
        int height = this.getHeight();
        int width = this.getWidth();
        int cy = height / 2;
        int cx = width / 2;
        int imheight = this.i.getHeight(null);
        int imwidth = this.i.getWidth(null);
        if (this.scale) {
            int scaleheight;
            int scalewidth;
            int imageratio = imwidth / imheight;
            int displayratio = width / height;
            if (imageratio >= displayratio) {
                scalewidth = width;
                scaleheight = width * imheight / imwidth;
            } else {
                scaleheight = height;
                scalewidth = height * imwidth / imheight;
            }
            g.drawImage(this.i, cx - scalewidth / 2, cy - scaleheight / 2, scalewidth, scaleheight, Color.black, null);
        } else {
            g.drawImage(this.i, cx - imwidth / 2, cy - imheight / 2, null);
        }
    }

    public void setScale(boolean b) {
        this.scale = b;
    }
}

