/*
 * Decompiled with CFR 0.152.
 */
package orc.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import orc.util.ParameterListener;

public class ParameterGUI {
    ArrayList<Param> paramlist = new ArrayList();
    HashMap<String, Param> parammap = new HashMap();
    JPanel panel = new JPanel(new GridBagLayout());
    int row = 0;
    GridBagConstraints gbc0;
    GridBagConstraints gbc1;
    GridBagConstraints gbc2;
    GridBagConstraints gbc2a;
    GridBagConstraints gbc2b;
    ArrayList<ParameterListener> listeners = new ArrayList();

    public ParameterGUI() {
        this.gbc0 = new GridBagConstraints();
        this.gbc0.gridx = 0;
        this.gbc0.weightx = 0.05;
        this.gbc0.fill = 2;
        this.gbc1 = new GridBagConstraints();
        this.gbc1.gridx = 1;
        this.gbc1.weightx = 0.05;
        this.gbc1.fill = 2;
        this.gbc2 = new GridBagConstraints();
        this.gbc2.gridx = 2;
        this.gbc2.weightx = 1.0;
        this.gbc2.gridwidth = 2;
        this.gbc2.fill = 2;
        this.gbc2a = new GridBagConstraints();
        this.gbc2a.gridx = 2;
        this.gbc2a.weightx = 1.0;
        this.gbc2a.fill = 2;
        this.gbc2b = new GridBagConstraints();
        this.gbc2b.gridx = 3;
        this.gbc2b.weightx = 1.0;
        this.gbc2b.fill = 2;
    }

    protected void notifyListeners(String name) {
        for (ParameterListener pl : this.listeners) {
            pl.parameterChanged(name);
        }
    }

    void add(String name, Param p) {
        this.paramlist.add(p);
        this.parammap.put(name, p);
        p.populate(this.panel);
        ++this.row;
    }

    public void addListener(ParameterListener l) {
        this.listeners.add(l);
    }

    public void addDouble(String name, String desc, double val) {
        DoubleFieldParam p = new DoubleFieldParam(name, desc, val);
        this.add(name, p);
    }

    public void addInt(String name, String desc, int val) {
        IntegerFieldParam p = new IntegerFieldParam(name, desc, val);
        this.add(name, p);
    }

    public void addIntSlider(String name, String desc, int min, int max, int val) {
        IntSliderFieldParam p = new IntSliderFieldParam(name, desc, min, max, val);
        this.add(name, p);
    }

    public void addDoubleSlider(String name, String desc, double min, double max, double val) {
        DoubleSliderFieldParam p = new DoubleSliderFieldParam(name, desc, min, max, val);
        this.add(name, p);
    }

    public void addString(String name, String desc, String def) {
        TextFieldParam p = new TextFieldParam(name, desc, def);
        this.add(name, p);
    }

    public void addBoolean(String name, String desc, boolean def) {
        CheckBoxParam p = new CheckBoxParam(name, desc, def);
        this.add(name, p);
    }

    public void addChoice(String name, String desc, String[] options, int def) {
        ComboBoxParam p = new ComboBoxParam(name, desc, options, def);
        this.add(name, p);
    }

    public void addButton(String name, String desc) {
        ButtonParam p = new ButtonParam(name, desc, new String[]{name});
        this.add(name, p);
    }

    public void addButtons(String name, String desc, String[] names) {
        ButtonParam p = new ButtonParam(name, desc, names);
        this.add(name, p);
    }

    public double gd(String name) {
        Param p = this.parammap.get(name);
        assert (p != null);
        assert (p instanceof DoubleValue);
        return ((DoubleValue)((Object)p)).getDoubleValue();
    }

    public void sd(String name, double v) {
        Param p = this.parammap.get(name);
        assert (p != null);
        assert (p instanceof DoubleValue);
        ((DoubleValue)((Object)p)).setDoubleValue(v);
    }

    public int gi(String name) {
        Param p = this.parammap.get(name);
        assert (p != null);
        assert (p instanceof IntegerValue);
        return ((IntegerValue)((Object)p)).getIntegerValue();
    }

    public void si(String name, int v) {
        Param p = this.parammap.get(name);
        assert (p != null);
        assert (p instanceof IntegerValue);
        ((IntegerValue)((Object)p)).setIntegerValue(v);
    }

    public void setMinMax(String name, int min, int max) {
        Param p = this.parammap.get(name);
        assert (p != null);
        assert (p instanceof BoundedIntegerValue);
        ((BoundedIntegerValue)((Object)p)).setMinMax(min, max);
    }

    public String gs(String name) {
        Param p = this.parammap.get(name);
        assert (p != null);
        assert (p instanceof StringValue);
        return ((StringValue)((Object)p)).getStringValue();
    }

    public void ss(String name, String v) {
        Param p = this.parammap.get(name);
        assert (p != null);
        assert (p instanceof StringValue);
        ((StringValue)((Object)p)).setStringValue(v);
    }

    public boolean gb(String name) {
        Param p = this.parammap.get(name);
        assert (p != null);
        assert (p instanceof BooleanValue);
        return ((BooleanValue)((Object)p)).getBooleanValue();
    }

    public void sb(String name, boolean v) {
        Param p = this.parammap.get(name);
        assert (p != null);
        assert (p instanceof BooleanValue);
        ((BooleanValue)((Object)p)).setBooleanValue(v);
    }

    public void setEnabled(String name, boolean e) {
        Param p = this.parammap.get(name);
        assert (p != null);
        p.setEnabled(e);
    }

    public Container getPanel() {
        return this.panel;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("ParameterGUI Test");
        f.setLayout(new BorderLayout());
        f.setSize(400, 400);
        ParameterGUI pg = new ParameterGUI();
        pg.addDouble("Double Value", "A double value", 3.1415926);
        pg.addInt("IntValue1", "An integer value", 45);
        pg.addIntSlider("IntValue2", "An integer value", 100, 1000, 999);
        pg.addDoubleSlider("DoubleSlider", "A sliding double", -1.0, 1.0, 0.5);
        pg.addDoubleSlider("DoubleSlider2", "Another sliding double", 2500000.0, 3000000.0, 2500000.0);
        pg.addString("StringValue1", "A string value", "Hi");
        pg.addString("StringValue2", "A string value", "world");
        pg.addBoolean("BoolVal1", "A boolean value", true);
        pg.addBoolean("BoolVal2", "A boolean value", false);
        pg.addChoice("Combo", "A combo box", new String[]{"Choice 1", "Choice 2", "Choice 3"}, 1);
        pg.addButton("Button", "button one");
        pg.addButtons("Buttons", "button one", new String[]{"One", "Two", "Three"});
        pg.addListener(new ParameterListener(){

            public void parameterChanged(String name) {
                System.out.println("Changed " + name);
            }
        });
        f.add((Component)pg.getPanel(), "Center");
        f.setVisible(true);
    }

    class ButtonParam
    extends Param
    implements ActionListener {
        JButton[] buttons;
        String[] names;

        public ButtonParam(String name, String desc, String[] names) {
            super(name, desc);
            this.names = names;
        }

        public void populate(Container c) {
            ParameterGUI.this.gbc0.gridy = ParameterGUI.this.row;
            ParameterGUI.this.gbc1.gridy = ParameterGUI.this.row;
            JPanel p = new JPanel(new GridLayout(1, this.names.length));
            this.buttons = new JButton[this.names.length];
            for (int i = 0; i < this.names.length; ++i) {
                this.buttons[i] = new JButton(this.names[i]);
                this.buttons[i].addActionListener(this);
                p.add(this.buttons[i]);
            }
            ParameterGUI.this.gbc2.gridy = ParameterGUI.this.row;
            c.add((Component)p, ParameterGUI.this.gbc2);
        }

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < this.names.length; ++i) {
                if (e.getSource() != this.buttons[i]) continue;
                ParameterGUI.this.notifyListeners(this.names[i]);
            }
        }

        public void setEnabled(boolean v) {
            for (JButton b : this.buttons) {
                b.setEnabled(v);
            }
        }
    }

    class CheckBoxParam
    extends Param
    implements ActionListener,
    BooleanValue {
        JCheckBox checkbox;
        boolean val;

        public CheckBoxParam(String name, String desc, boolean val) {
            super(name, desc);
            this.val = val;
        }

        public void populate(Container c) {
            this.populateBase(c);
            this.checkbox = new JCheckBox();
            this.checkbox.setSelected(this.val);
            this.checkbox.addActionListener(this);
            ParameterGUI.this.gbc2.gridy = ParameterGUI.this.row;
            c.add((Component)this.checkbox, ParameterGUI.this.gbc2);
        }

        public void actionPerformed(ActionEvent e) {
            ParameterGUI.this.notifyListeners(this.name);
        }

        public boolean getBooleanValue() {
            return this.checkbox.isSelected();
        }

        public void setBooleanValue(boolean v) {
            this.checkbox.setSelected(v);
        }

        public void setEnabled(boolean v) {
            this.checkbox.setEnabled(v);
        }
    }

    class ComboBoxParam
    extends Param
    implements ActionListener,
    IntegerValue,
    StringValue {
        JComboBox box;
        String[] options;
        int val;

        public ComboBoxParam(String name, String desc, String[] options, int val) {
            super(name, desc);
            this.val = val;
            this.options = options;
        }

        public void populate(Container c) {
            this.populateBase(c);
            this.box = new JComboBox<String>(this.options);
            this.box.setSelectedIndex(this.val);
            this.box.addActionListener(this);
            ParameterGUI.this.gbc2.gridy = ParameterGUI.this.row;
            c.add((Component)this.box, ParameterGUI.this.gbc2);
        }

        public void actionPerformed(ActionEvent e) {
            ParameterGUI.this.notifyListeners(this.name);
        }

        public int getIntegerValue() {
            return this.box.getSelectedIndex();
        }

        public void setIntegerValue(int i) {
            this.box.setSelectedIndex(i);
        }

        public String getStringValue() {
            return this.options[this.box.getSelectedIndex()];
        }

        public void setStringValue(String s) {
            for (int i = 0; i < this.options.length; ++i) {
                if (!this.options[i].equals(s)) continue;
                this.box.setSelectedIndex(i);
                return;
            }
        }

        public void setEnabled(boolean v) {
            this.box.setEnabled(v);
        }
    }

    class IntSliderFieldParam
    extends Param
    implements ChangeListener,
    ActionListener,
    FocusListener,
    IntegerValue,
    BoundedIntegerValue {
        JTextField field;
        JSlider slider;
        int min;
        int max;
        int val;

        public IntSliderFieldParam(String name, String desc, int min, int max, int val) {
            super(name, desc);
            this.min = min;
            this.max = max;
            this.val = val;
        }

        public void populate(Container c) {
            this.populateBase(c);
            this.field = new JTextField("" + this.val);
            this.field.addActionListener(this);
            this.field.addFocusListener(this);
            this.slider = new JSlider(this.min, this.max, this.val);
            this.slider.addChangeListener(this);
            ParameterGUI.this.gbc2a.gridy = ParameterGUI.this.row;
            ParameterGUI.this.gbc2b.gridy = ParameterGUI.this.row;
            ParameterGUI.this.gbc2a.weightx = 1.0;
            ParameterGUI.this.gbc2b.weightx = 0.3;
            c.add((Component)this.slider, ParameterGUI.this.gbc2a);
            c.add((Component)this.field, ParameterGUI.this.gbc2b);
        }

        public void stateChanged(ChangeEvent e) {
            this.field.setText("" + this.slider.getValue());
            ParameterGUI.this.notifyListeners(this.name);
        }

        public void actionPerformed(ActionEvent e) {
            int v;
            try {
                v = Integer.parseInt(this.field.getText());
            }
            catch (Exception ex) {
                return;
            }
            if (v < this.min) {
                v = this.min;
            }
            if (v > this.max) {
                v = this.max;
            }
            this.field.setText("" + v);
            this.slider.setValue(v);
            ParameterGUI.this.notifyListeners(this.name);
        }

        public int getIntegerValue() {
            return this.slider.getValue();
        }

        public void setIntegerValue(int v) {
            this.slider.setValue(v);
        }

        public void setEnabled(boolean v) {
            this.field.setEnabled(v);
            this.slider.setEnabled(v);
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            ParameterGUI.this.notifyListeners(this.name);
        }

        public void setMinMax(int min, int max) {
            this.min = min;
            this.max = max;
            this.slider.setMinimum(min);
            this.slider.setMaximum(max);
        }
    }

    class DoubleSliderFieldParam
    extends Param
    implements ChangeListener,
    ActionListener,
    FocusListener,
    DoubleValue {
        JTextField field;
        JSlider slider;
        static final int STEPS = 10000;
        double stepsize;
        double min;
        double max;
        double val;

        public DoubleSliderFieldParam(String name, String desc, double min, double max, double val) {
            super(name, desc);
            this.min = min;
            this.max = max;
            this.val = val;
            this.stepsize = (max - min) / 10000.0;
        }

        public void populate(Container c) {
            this.populateBase(c);
            this.field = new JTextField("" + this.val);
            this.field.addActionListener(this);
            this.field.addFocusListener(this);
            this.slider = new JSlider(0, 10000, (int)((this.val - this.min) / this.stepsize));
            this.slider.addChangeListener(this);
            ParameterGUI.this.gbc2a.gridy = ParameterGUI.this.row;
            ParameterGUI.this.gbc2b.gridy = ParameterGUI.this.row;
            ParameterGUI.this.gbc2a.weightx = 1.0;
            ParameterGUI.this.gbc2b.weightx = 0.3;
            c.add((Component)this.slider, ParameterGUI.this.gbc2a);
            c.add((Component)this.field, ParameterGUI.this.gbc2b);
        }

        public void stateChanged(ChangeEvent e) {
            int digits = (int)(-Math.log(this.stepsize) / Math.log(10.0)) + 1;
            if (digits < 0) {
                digits = 0;
            }
            this.field.setText(String.format("%." + digits + "f", (double)this.slider.getValue() * this.stepsize + this.min));
            ParameterGUI.this.notifyListeners(this.name);
        }

        public void actionPerformed(ActionEvent e) {
            double v;
            try {
                v = Double.parseDouble(this.field.getText());
            }
            catch (Exception ex) {
                return;
            }
            if (v < this.min) {
                v = this.min;
            }
            if (v > this.max) {
                v = this.max;
            }
            this.field.setText("" + v);
            this.slider.setValue((int)((v - this.min) / this.stepsize));
            ParameterGUI.this.notifyListeners(this.name);
        }

        public double getDoubleValue() {
            return (double)this.slider.getValue() * this.stepsize + this.min;
        }

        public void setDoubleValue(double v) {
            this.slider.setValue((int)((v - this.min) / this.stepsize));
        }

        public void setEnabled(boolean v) {
            this.slider.setEnabled(v);
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            ParameterGUI.this.notifyListeners(this.name);
        }
    }

    class DoubleFieldParam
    extends Param
    implements DoubleValue,
    ActionListener,
    FocusListener {
        JTextField field;
        double def;

        public DoubleFieldParam(String name, String desc, double def) {
            super(name, desc);
            this.def = def;
        }

        public void populate(Container c) {
            this.populateBase(c);
            this.field = new JTextField("" + this.def);
            this.field.addActionListener(this);
            this.field.addFocusListener(this);
            ParameterGUI.this.gbc2.gridy = ParameterGUI.this.row;
            c.add((Component)this.field, ParameterGUI.this.gbc2);
        }

        public double getDoubleValue() {
            try {
                return Double.parseDouble(this.field.getText());
            }
            catch (Exception ex) {
                return 0.0;
            }
        }

        public void setDoubleValue(double v) {
            this.field.setText("" + v);
        }

        public void setEnabled(boolean v) {
            this.field.setEnabled(v);
        }

        public void actionPerformed(ActionEvent e) {
            ParameterGUI.this.notifyListeners(this.name);
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            ParameterGUI.this.notifyListeners(this.name);
        }
    }

    class IntegerFieldParam
    extends Param
    implements IntegerValue,
    ActionListener,
    FocusListener {
        JTextField field;
        int def;

        public IntegerFieldParam(String name, String desc, int def) {
            super(name, desc);
            this.def = def;
        }

        public void populate(Container c) {
            this.populateBase(c);
            this.field = new JTextField("" + this.def);
            this.field.addActionListener(this);
            this.field.addFocusListener(this);
            ParameterGUI.this.gbc2.gridy = ParameterGUI.this.row;
            c.add((Component)this.field, ParameterGUI.this.gbc2);
        }

        public int getIntegerValue() {
            try {
                return Integer.parseInt(this.field.getText());
            }
            catch (Exception ex) {
                return 0;
            }
        }

        public void setIntegerValue(int v) {
            this.field.setText("" + v);
        }

        public void setEnabled(boolean v) {
            this.field.setEnabled(v);
        }

        public void actionPerformed(ActionEvent e) {
            ParameterGUI.this.notifyListeners(this.name);
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            ParameterGUI.this.notifyListeners(this.name);
        }
    }

    class TextFieldParam
    extends Param
    implements StringValue,
    ActionListener,
    FocusListener {
        JTextField field;
        String def;

        public TextFieldParam(String name, String desc, String def) {
            super(name, desc);
            this.def = def;
        }

        public void populate(Container c) {
            this.populateBase(c);
            this.field = new JTextField(this.def);
            this.field.addActionListener(this);
            this.field.addFocusListener(this);
            ParameterGUI.this.gbc2.gridy = ParameterGUI.this.row;
            c.add((Component)this.field, ParameterGUI.this.gbc2);
        }

        public String getStringValue() {
            return this.field.getText();
        }

        public void setStringValue(String v) {
            this.field.setText(v);
        }

        public void setEnabled(boolean v) {
            this.field.setEnabled(v);
        }

        public void actionPerformed(ActionEvent e) {
            ParameterGUI.this.notifyListeners(this.name);
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            ParameterGUI.this.notifyListeners(this.name);
        }
    }

    abstract class Param {
        String name;
        String desc;

        public Param(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        protected void populateBase(Container c) {
            ParameterGUI.this.gbc0.gridy = ParameterGUI.this.row;
            ParameterGUI.this.gbc1.gridy = ParameterGUI.this.row;
            c.add((Component)new JLabel(this.desc), ParameterGUI.this.gbc1);
        }

        public abstract void populate(Container var1);

        public abstract void setEnabled(boolean var1);
    }

    static interface BooleanValue {
        public boolean getBooleanValue();

        public void setBooleanValue(boolean var1);
    }

    static interface StringValue {
        public String getStringValue();

        public void setStringValue(String var1);
    }

    static interface BoundedIntegerValue {
        public void setMinMax(int var1, int var2);
    }

    static interface IntegerValue {
        public int getIntegerValue();

        public void setIntegerValue(int var1);
    }

    static interface DoubleValue {
        public double getDoubleValue();

        public void setDoubleValue(double var1);
    }
}

