/*
 * Decompiled with CFR 0.152.
 */
package maslab.data;

import java.util.ArrayList;
import maslab.data.ClockEventSource;

public class Clock {
    double timeDialation = 1.0;
    double systemTimeOffset = 0.0;
    double eventTime = 0.0;
    ArrayList<ClockEventSource> eventSources = new ArrayList();
    boolean timeIsUnmetered = false;
    boolean started = false;
    EventThread eventThread;

    public Clock() {
        this(1.0);
        this.start();
    }

    public Clock(double timeDialation) {
        this.timeDialation = timeDialation;
        if (timeDialation <= 0.0) {
            this.timeIsUnmetered = true;
        }
        this.eventThread = new EventThread();
    }

    public Thread getEventThread() {
        return this.eventThread;
    }

    public void start() {
        this.systemTimeOffset = (double)System.currentTimeMillis() / 1000.0;
        this.eventThread.start();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventSource(ClockEventSource source) {
        ArrayList<ClockEventSource> arrayList = this.eventSources;
        synchronized (arrayList) {
            this.eventSources.add(source);
            this.eventSources.notifyAll();
        }
    }

    public void forceRealtime() {
        this.timeDialation = 1.0;
        this.timeIsUnmetered = false;
    }

    public double getTime() {
        if (!this.started) {
            return 0.0;
        }
        if (!this.timeIsUnmetered) {
            return ((double)System.currentTimeMillis() / 1000.0 - this.systemTimeOffset) * this.timeDialation;
        }
        return this.eventTime;
    }

    public double getWallTime() {
        return (double)System.currentTimeMillis() / 1000.0 - this.systemTimeOffset;
    }

    public void sleepUntilTime(double time) {
        this.sleep(time - this.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(double ms) {
        if (this.timeIsUnmetered || !this.started) {
            SleepEventSource ses;
            SleepEventSource sleepEventSource = ses = new SleepEventSource(this.getTime() + ms);
            synchronized (sleepEventSource) {
                this.addEventSource(ses);
                try {
                    ses.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
        double sleepms = ms / this.timeDialation;
        try {
            if (sleepms > 0.0) {
                Thread.sleep((int)sleepms);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class EventThread
    extends Thread {
        EventThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            block8: while (true) {
                nextEventTime = Infinity;
                var3_2 = Clock.this.eventSources;
                // MONITORENTER : var3_2
                while (true) {
                    block15: {
                        if (Clock.this.eventSources.size() == 0) break block15;
                        li = Clock.this.eventSources.listIterator(0);
                        if (true) ** GOTO lbl25
                    }
                    try {
                        Clock.this.eventSources.wait();
                    }
                    catch (InterruptedException var4_4) {
                        // empty catch block
                    }
                }
                do {
                    if ((thisEventTime = (source = li.next()).timeOfNextEvent()) < 0.0) {
                        li.remove();
                        continue;
                    }
                    nextEventTime = Math.min(thisEventTime, nextEventTime);
lbl25:
                    // 3 sources

                } while (li.hasNext());
                // MONITOREXIT : var3_2
                Clock.this.eventTime = nextEventTime;
                if (!Clock.this.timeIsUnmetered) {
                    Clock.this.sleepUntilTime(Clock.this.eventTime);
                }
                Clock.this.eventTime = Math.max(Clock.this.eventTime, Clock.this.getTime());
                var3_2 = Clock.this.eventSources;
                // MONITORENTER : var3_2
                var5_5 = Clock.this.eventSources.iterator();
                while (true) {
                    if (!var5_5.hasNext()) {
                        // MONITOREXIT : var3_2
                        continue block8;
                    }
                    source = var5_5.next();
                    source.timeChanged(Clock.this.eventTime);
                }
                break;
            }
            catch (Throwable v1) {
                // MONITOREXIT : var3_2
                throw v1;
            }
        }
    }

    class SleepEventSource
    implements ClockEventSource {
        double goalTime;

        SleepEventSource(double goalTime) {
            this.goalTime = goalTime;
        }

        @Override
        public double timeOfNextEvent() {
            return this.goalTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeChanged(double theTime) {
            if (theTime < this.goalTime) {
                return;
            }
            this.goalTime = -1.0;
            SleepEventSource sleepEventSource = this;
            synchronized (sleepEventSource) {
                this.notifyAll();
            }
        }
    }
}

