/*
 * Decompiled with CFR 0.152.
 */
package maslab.data;

import java.io.IOException;
import maslab.data.Clock;
import maslab.data.ClockEventSource;
import maslab.data.DataLogReader;
import maslab.util.Logger;

public class DataLogRunner {
    DataLogReader reader;
    Clock clock;
    Logger log = new Logger(this);
    DataLogReader.SourceEventPair nextP;
    double starttime = 0.0;

    public DataLogRunner(Clock clock, String logspec) throws IOException {
        this(clock, new DataLogReader(logspec));
    }

    public DataLogRunner(Clock clock, DataLogReader reader) {
        this(clock, reader, 0.0);
    }

    public DataLogRunner(Clock clock, DataLogReader reader, double starttime) {
        this.clock = clock;
        this.reader = reader;
        this.starttime = starttime;
        try {
            do {
                this.nextP = reader.next();
            } while (this.nextP != null && this.nextP.event.getTimeStamp() < starttime);
        }
        catch (IOException ex) {
            this.log.error("Couldn't read log file", ex);
        }
        clock.addEventSource(new LogEventSource());
    }

    class LogEventSource
    implements ClockEventSource {
        LogEventSource() {
        }

        @Override
        public double timeOfNextEvent() {
            if (DataLogRunner.this.nextP == null) {
                return -1.0;
            }
            return DataLogRunner.this.nextP.event.getTimeStamp();
        }

        @Override
        public void timeChanged(double theTime) {
            while (DataLogRunner.this.nextP != null && DataLogRunner.this.nextP.event.getTimeStamp() <= theTime) {
                DataLogRunner.this.nextP.source.notifyDataListeners(DataLogRunner.this.nextP.event);
                try {
                    DataLogRunner.this.nextP = DataLogRunner.this.reader.next();
                }
                catch (IOException ex) {
                    DataLogRunner.this.log.error("Couldn't read log file", ex);
                }
            }
        }
    }
}

