/*
 * Decompiled with CFR 0.152.
 */
package maslab.data;

import java.util.ArrayList;
import maslab.data.DataEvent;
import maslab.data.DataListener;
import maslab.data.DataLogWriter;
import maslab.data.SimpleProperties;

public abstract class DataSource {
    protected ArrayList<DataListener> dataListeners = new ArrayList();
    protected ArrayList<DataLogWriter> logWriters = new ArrayList();
    protected String channelName;

    public DataSource(String channelName) {
        this.channelName = channelName;
    }

    public synchronized void addDataListener(DataListener l) {
        if (!this.dataListeners.contains(l)) {
            this.dataListeners.add(l);
        }
    }

    public synchronized void removeDataListener(DataListener l) {
        this.dataListeners.remove(l);
    }

    synchronized void addDataLogWriter(DataLogWriter l) {
        if (!this.logWriters.contains(l)) {
            this.logWriters.add(l);
        }
    }

    public void notifyLogWriters(double timestamp, String data) {
        for (DataLogWriter l : this.logWriters) {
            l.writeEvent(this, timestamp, data);
        }
    }

    protected synchronized void notifyDataListeners(DataEvent e) {
        for (DataListener l : this.dataListeners) {
            l.processDataEvent(this, e);
        }
    }

    public abstract DataEvent stringToEvent(double var1, String var3);

    public abstract String getParameters();

    public abstract void setParameters(String var1);

    public String getChannelName() {
        return this.channelName;
    }

    public SimpleProperties parseProperties(String data) {
        String[] toks;
        SimpleProperties sp = new SimpleProperties();
        String[] stringArray = toks = data.split("\\s+");
        int n = toks.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            int equalpos = t.indexOf(61);
            if (equalpos < 0) {
                sp.put(t, "1");
            } else {
                String key = t.substring(0, equalpos);
                String val = t.substring(equalpos + 1);
                sp.put(key, val);
            }
            ++n2;
        }
        return sp;
    }

    /*
     * Unable to fully structure code
     */
    public static final String[] fsplit(String s, int maxtoks) {
        out = new String[maxtoks];
        outidx = 0;
        pos = 0;
        len = s.length();
        ** GOTO lbl15
        {
            ++pos;
            do {
                if (pos < len && s.charAt(pos) == '\t' || s.charAt(pos) == ' ') continue block0;
                start = pos;
                while (pos < len && s.charAt(pos) != '\t' && s.charAt(pos) != ' ') {
                    ++pos;
                }
                end = pos;
                out[outidx++] = s.substring(start, end);
lbl15:
                // 2 sources

            } while (pos < len && outidx < maxtoks);
        }
        return out;
    }

    public static final double parseDouble(String s) {
        double v = 0.0;
        int len = s.length();
        int pos = 0;
        boolean minus = false;
        boolean decimal = false;
        double fraction = 0.1;
        while (pos < len) {
            char c = s.charAt(pos);
            switch (c) {
                case '-': {
                    minus = true;
                    break;
                }
                case '.': {
                    decimal = true;
                    break;
                }
                default: {
                    int digit = c - 48;
                    if (decimal) {
                        v += (double)digit * fraction;
                        fraction *= 0.1;
                        break;
                    }
                    v *= 10.0;
                    v += (double)digit;
                }
            }
            ++pos;
        }
        return v;
    }
}

