/*
 * Decompiled with CFR 0.152.
 */
package maslab.examples;

import java.io.IOException;
import maslab.telemetry.JugLoggerPublisher;
import maslab.util.Logger;
import maslab.util.StringUtil;
import orc.Gyro;
import orc.IRRangeFinder;
import orc.Motor;
import orc.Orc;
import orc.Servo;

public class SimpleRobot {
    Orc orc = Orc.makeOrc();
    Motor leftMotor = new Motor(this.orc, 0, true);
    Motor rightMotor = new Motor(this.orc, 1, false);
    Gyro gyro = new Gyro(this.orc, 1);
    IRRangeFinder forwardIR = IRRangeFinder.makeGP2D12((Orc)this.orc, (int)8);
    Servo servo = Servo.makeMPIMX400((Orc)this.orc, (int)0);
    Logger log = new Logger(this);
    JugLoggerPublisher logPublisher = new JugLoggerPublisher("LogMessage");
    static final long RUNTIME = 25L;

    public static void main(String[] args) {
        SimpleRobot robot;
        try {
            robot = new SimpleRobot();
        }
        catch (Exception ex) {
            System.out.println("Couldn't start: " + ex);
            return;
        }
        robot.run();
    }

    public SimpleRobot() throws IOException {
        this.logPublisher.setLevel("SimpleRobot", 4);
    }

    public void run() {
        long starttime = System.currentTimeMillis();
        this.logPublisher.publishUnconditional("SimpleRobot", 4, "Calibrating Gyro");
        this.gyro.calibrate(1000.0);
        this.logPublisher.publishUnconditional("SimpleRobot", 4, "done.\n");
        this.leftMotor.setWatchDog(0);
        this.logPublisher.publishUnconditional("SimpleRobot", 4, "Starting...\n");
        double lastReportedTime = 0.0;
        boolean driving = false;
        while (true) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            double time = (double)(System.currentTimeMillis() - starttime) / 1000.0;
            if (time > 25.0) break;
            if (time > lastReportedTime + 1.0) {
                double timeRemaining = 25.0 - time;
                this.logPublisher.publishUnconditional("SimpleRobot", 4, StringUtil.padLeft("" + (int)timeRemaining, 4, ' '));
                lastReportedTime += 1.0;
            }
            double range = this.forwardIR.getRange();
            if (driving) {
                this.log.output("range = " + String.format("%.2f", range) + ". driving");
            } else {
                this.log.output("range = " + StringUtil.formatDouble(range, 2) + ". stopped");
            }
            if (range > 0.35) {
                driving = true;
                this.leftMotor.setPWM(0.75);
                this.rightMotor.setPWM(0.75);
                this.servo.setPosition(0.0);
                continue;
            }
            if (!driving) continue;
            this.logPublisher.publishUnconditional("SimpleRobot", 4, "Look out!\n");
            driving = false;
            this.leftMotor.setPWM(0.0);
            this.rightMotor.setPWM(0.0);
            this.servo.setPosition(1.0);
        }
        this.logPublisher.publishUnconditional("SimpleRobot", 4, "Stopping! Press a key...\n");
        this.leftMotor.setPWM(0.0);
        this.rightMotor.setPWM(0.0);
    }
}

