/*
 * Decompiled with CFR 0.152.
 */
package maslab.odom;

import maslab.data.DataEvent;
import maslab.data.DataSource;
import maslab.data.SimpleProperties;
import maslab.odom.OdomData;
import maslab.util.Logger;

public class DifferentialOdometryDataSource
extends DataSource {
    protected double leftTickMeters;
    protected double rightTickMeters;
    protected double baseLineMeters;
    protected boolean swapLeftRight = false;
    Logger log = new Logger(this);

    public DifferentialOdometryDataSource(String channelName) {
        super(channelName);
    }

    @Override
    public DataEvent stringToEvent(double timestamp, String data) {
        String[] toks = data.split("\\s+");
        double leftTicks = Double.parseDouble(toks[0]);
        double rightTicks = Double.parseDouble(toks[1]);
        if (this.swapLeftRight) {
            double temp = leftTicks;
            leftTicks = rightTicks;
            rightTicks = temp;
        }
        return this.leftRightToEvent(timestamp, leftTicks, rightTicks);
    }

    protected OdomData leftRightToEvent(double timestamp, double leftTicks, double rightTicks) {
        double right = rightTicks * this.rightTickMeters;
        double left = leftTicks * this.leftTickMeters;
        double dL = (right + left) / 2.0;
        double dT = (right - left) / this.baseLineMeters;
        OdomData od = new OdomData(timestamp, dL * Math.cos(dT), dL * Math.sin(dT), dT);
        return od;
    }

    @Override
    public String getParameters() {
        return String.format("leftTickMeters=%f rightTickMeters=%f baseLineMeters=%f", this.leftTickMeters, this.rightTickMeters, this.baseLineMeters);
    }

    @Override
    public void setParameters(String s) {
        SimpleProperties sp = this.parseProperties(s);
        try {
            this.leftTickMeters = sp.requireDouble("leftTickMeters");
            this.rightTickMeters = sp.requireDouble("rightTickMeters");
            this.baseLineMeters = sp.requireDouble("baseLineMeters");
            this.swapLeftRight = sp.getBoolean("swapLeftRight", false);
        }
        catch (RuntimeException ex) {
            this.log.error("Missing required data field.", ex);
        }
    }
}

