/*
 * Decompiled with CFR 0.152.
 */
package maslab.odom;

import Jama.Matrix;
import maslab.data.DataEvent;
import maslab.data.DataSource;
import maslab.data.SimpleProperties;
import maslab.geom.GeomUtil;
import maslab.odom.OdomData;
import maslab.util.Logger;

public class IntegratedOdometryDataSource
extends DataSource {
    Matrix lastXYT = new Matrix(3, 1);
    double thetaOffset = 0.0;
    boolean firstTime = true;
    Logger log = new Logger(this);

    public IntegratedOdometryDataSource(String channelName) {
        super(channelName);
    }

    @Override
    public DataEvent stringToEvent(double timestamp, String data) {
        String[] toks = data.split("\\s+");
        Matrix xyt = new Matrix(3, 1);
        xyt.set(0, 0, Double.parseDouble(toks[0]));
        xyt.set(1, 0, Double.parseDouble(toks[1]));
        xyt.set(2, 0, Double.parseDouble(toks[2]) + this.thetaOffset);
        if (this.firstTime) {
            this.lastXYT = xyt;
            this.firstTime = false;
            return null;
        }
        Matrix rxyt = GeomUtil.relativeTo(xyt, this.lastXYT);
        this.lastXYT = xyt;
        double dist = Math.pow(rxyt.get(0, 0), 2.0) + Math.pow(rxyt.get(1, 0), 2.0);
        if (dist > 5.0) {
            this.log.warn("Big odometry jump of " + dist + " at t=" + timestamp);
        }
        return new OdomData(timestamp, rxyt.get(0, 0), rxyt.get(1, 0), rxyt.get(2, 0));
    }

    @Override
    public String getParameters() {
        return "thetaOffset=" + this.thetaOffset;
    }

    @Override
    public void setParameters(String s) {
        SimpleProperties sp = this.parseProperties(s);
        this.thetaOffset = sp.getDouble("thetaOffset", 0.0);
    }
}

