/*
 * Decompiled with CFR 0.152.
 */
package maslab.telemetry;

import maslab.telemetry.channel.TextChannel;
import maslab.util.Logger;
import maslab.util.LoggerPublisher;
import maslab.util.StringUtil;

public class JugLoggerPublisher
extends LoggerPublisher {
    TextChannel channel;

    public JugLoggerPublisher(String name) {
        this.channel = new TextChannel(name);
        Logger.addPublisher(this);
    }

    @Override
    public void publishUnconditional(String name, int level, String message) {
        long nowTime = System.currentTimeMillis();
        double elapsedTime = (double)(nowTime - Logger.startTime) / 1000.0;
        String levelName = Logger.levelToString(level);
        this.channel.publish(String.valueOf(StringUtil.padRight(name, 20, ' ')) + StringUtil.padLeft(StringUtil.formatDouble(elapsedTime, 3), 10, ' ') + " " + StringUtil.padRight(levelName, 10, ' ') + message + '\n');
    }
}

