/*
 * Decompiled with CFR 0.152.
 */
package maslab.telemetry.botclient;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import maslab.telemetry.JugClient;
import maslab.telemetry.StatusListener;
import maslab.telemetry.botclient.ControlPanel;
import maslab.telemetry.botclient.ManualAdd;
import maslab.telemetry.botclient.Plugin;
import maslab.telemetry.botclient.PluginController;
import maslab.util.Logger;

public class BotClient
extends JFrame
implements ActionListener {
    public static final long serialVersionUID = 1001L;
    public static String version = "4.0";
    static Logger log = new Logger("BotClient");
    public static JDesktopPane aDesktop;
    JugClient jc;
    PluginController pc;
    JDesktopPane desktop;
    JLabel statusBar;

    public static void main(String[] args) {
        Logger.consolePublisher.setGlobalLevel(3);
        new BotClient();
    }

    public BotClient() {
        this.setSize(800, 600);
        this.setTitle("BotClient");
        this.getContentPane().setLayout(new BorderLayout());
        this.createMenus();
        this.desktop = new JDesktopPane();
        this.desktop.setBackground(Color.blue);
        aDesktop = this.desktop;
        this.getContentPane().add((Component)this.desktop, "Center");
        this.statusBar = new JLabel("BotClient version " + version);
        this.getContentPane().add((Component)this.statusBar, "South");
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.jc = new JugClient();
        this.jc.advertise("USERCMD$hidden");
        this.pc = new PluginController();
        ControlPanel cp = new ControlPanel(this);
        this.jc.addStatusListener(cp);
        this.desktop.add(cp);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s == "Exit") {
            System.exit(0);
        }
        if (s == "New Channel View") {
            new ManualAdd(this);
        }
    }

    void createMenus() {
        JMenuBar mb = new JMenuBar();
        this.setJMenuBar(mb);
        JMenu m = new JMenu("File");
        m.setMnemonic(70);
        mb.add(m);
        JMenuItem i = new JMenuItem("Exit", 88);
        m.add(i);
        i.addActionListener(this);
        m = new JMenu("View");
        m.setMnemonic(86);
        mb.add(m);
        i = new JMenuItem("New Channel View", 78);
        m.add(i);
        i.addActionListener(this);
    }

    public void setIP(InetAddress ip) {
        try {
            this.jc.reconnect(ip, 7780);
        }
        catch (IOException ex) {
            log.log(1, "Error reconnecting to " + ip, ex);
        }
    }

    public void userCommand(String cmd) {
        byte[] data = cmd.getBytes();
        this.jc.publish("USERCMD$hidden", data);
    }

    public ArrayList<String> getChannels() {
        return this.jc.getChannels();
    }

    String[] getPlugins(String type) {
        return this.pc.getPlugins(type);
    }

    String[] getTypes() {
        return this.pc.getTypes();
    }

    public void newDefaultHandler(String channel, String type) {
        String pluginName = this.pc.getDefaultPlugin(type);
        if (pluginName == null) {
            return;
        }
        this.newHandler(channel, type, pluginName);
    }

    public void newHandler(String channel, String type, String pluginName) {
        JInternalFrame frame = new JInternalFrame();
        Plugin p = this.pc.newHandler(pluginName, frame);
        if (p == null) {
            return;
        }
        Watchdog w = new Watchdog(p);
        frame.addInternalFrameListener(w);
        this.desktop.add(frame);
        frame.setLocation(this.desktop.getWidth() / 2 - frame.getWidth() / 2, this.desktop.getHeight() / 2 - frame.getHeight() / 2);
        if (!p.addChannel(channel, type)) {
            JOptionPane.showMessageDialog(this.desktop, String.valueOf(pluginName) + " is unable to handle channel" + channel + " of type " + type);
            return;
        }
        w.channels.add(String.valueOf(channel) + "$" + type);
        this.jc.subscribe(String.valueOf(channel) + "$" + type, p);
        try {
            StatusListener listen = (StatusListener)((Object)p);
            this.jc.addStatusListener(listen);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    class Watchdog
    extends InternalFrameAdapter {
        Plugin plugin;
        public HashSet<String> channels;

        public Watchdog(Plugin plugin) {
            this.plugin = plugin;
            this.channels = new HashSet();
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent e) {
            Iterator<String> i = this.channels.iterator();
            while (i.hasNext()) {
                BotClient.this.jc.unsubscribe(i.next(), this.plugin);
            }
            try {
                StatusListener listen = (StatusListener)((Object)this.plugin);
                BotClient.this.jc.removeStatusListener(listen);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }
}

