/*
 * Decompiled with CFR 0.152.
 */
package maslab.telemetry.botclient;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import maslab.telemetry.botclient.BotClient;
import maslab.telemetry.botclient.PluginController;

class ManualAdd
extends JFrame
implements ActionListener {
    JTextField namefield;
    JComboBox typebox;
    JComboBox pluginbox;
    JButton okbutton;
    JButton cancelbutton;
    BotClient bc;
    static final long serialVersionUID = 1001L;

    public ManualAdd(BotClient bc) {
        this.bc = bc;
        this.setTitle("Add a Viewer");
        this.setBackground(Color.lightGray);
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.getContentPane().setLayout(gb);
        JLabel label = new JLabel("Channel Name");
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 16;
        c.fill = 0;
        c.insets = new Insets(5, 15, 0, 15);
        gb.setConstraints(label, c);
        this.getContentPane().add(label);
        this.namefield = new JTextField();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 10;
        gb.setConstraints(this.namefield, c);
        this.getContentPane().add(this.namefield);
        label = new JLabel("Channel Type");
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 16;
        c.insets = new Insets(5, 15, 0, 15);
        gb.setConstraints(label, c);
        this.getContentPane().add(label);
        this.typebox = new JComboBox<String>(bc.getTypes());
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 10;
        gb.setConstraints(this.typebox, c);
        this.getContentPane().add(this.typebox);
        this.typebox.addActionListener(this);
        label = new JLabel("Plugin");
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 16;
        c.insets = new Insets(5, 15, 0, 15);
        gb.setConstraints(label, c);
        this.getContentPane().add(label);
        String[] plugins = bc.getPlugins((String)this.typebox.getSelectedItem());
        int i = 0;
        while (i < plugins.length) {
            plugins[i] = PluginController.shortName(plugins[i]);
            ++i;
        }
        this.pluginbox = new JComboBox<String>(plugins);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 2;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 10;
        gb.setConstraints(this.pluginbox, c);
        this.getContentPane().add(this.pluginbox);
        this.pluginbox.addActionListener(this);
        JPanel pan = new JPanel();
        c.gridwidth = 3;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 1;
        c.anchor = 10;
        gb.setConstraints(pan, c);
        this.getContentPane().add(pan);
        gb = new GridBagLayout();
        pan.setLayout(gb);
        this.okbutton = new JButton("OK");
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 10;
        c.fill = 0;
        gb.setConstraints(this.okbutton, c);
        pan.add(this.okbutton);
        this.okbutton.addActionListener(this);
        this.cancelbutton = new JButton("Cancel");
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 10;
        c.fill = 0;
        c.weightx = 1.0;
        gb.setConstraints(this.cancelbutton, c);
        pan.add(this.cancelbutton);
        this.cancelbutton.addActionListener(this);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.typebox) {
            this.pluginbox.removeAllItems();
            String[] plugins = this.bc.getPlugins((String)this.typebox.getSelectedItem());
            int i = 0;
            while (i < plugins.length) {
                plugins[i] = PluginController.shortName(plugins[i]);
                this.pluginbox.addItem(plugins[i]);
                ++i;
            }
        }
        if (e.getSource() == this.cancelbutton) {
            this.setVisible(false);
        }
        if (e.getSource() == this.okbutton) {
            if (this.namefield.getText().equals("")) {
                JOptionPane.showMessageDialog(this, "You must enter a channel name.");
                return;
            }
            this.bc.newHandler(this.namefield.getText(), (String)this.typebox.getSelectedItem(), (String)this.pluginbox.getSelectedItem());
            this.setVisible(false);
        }
    }
}

