/*
 * Decompiled with CFR 0.152.
 */
package maslab.telemetry.botclient;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JInternalFrame;
import maslab.telemetry.botclient.DefaultHandlers;
import maslab.telemetry.botclient.Plugin;
import maslab.util.Logger;

class PluginController {
    HashMap<String, HashSet<Class>> types = new HashMap();
    DefaultHandlers dh;
    HashMap<Plugin, HashSet<String>> subscriptions;
    public static Logger log = new Logger("PluginController");

    public PluginController() {
        HashSet<String> names = new HashSet<String>();
        names.add("maslab.telemetry.botclient.TextPlugin");
        names.add("maslab.telemetry.botclient.ImagePlugin");
        names.add("maslab.telemetry.botclient.VectorPlugin");
        names.add("maslab.telemetry.botclient.ScopePlugin");
        this.loadPlugins(names);
        this.dh = new DefaultHandlers(this);
    }

    public static String shortName(String pluginName) {
        int c = pluginName.lastIndexOf(".");
        if (c == -1) {
            return pluginName;
        }
        return pluginName.substring(c + 1, pluginName.length());
    }

    void loadPlugins(HashSet<String> names) {
        log.verbose("Loading plugins...");
        for (String name : names) {
            try {
                Class<?> c = Class.forName(name);
                String typeStrings = (String)c.getField("types").get(null);
                log.verbose("Loaded plugin " + PluginController.shortName(name) + " for types " + typeStrings);
                StringTokenizer st = new StringTokenizer(typeStrings, ",");
                while (st.hasMoreTokens()) {
                    HashSet<Object> s;
                    String t = st.nextToken();
                    if (this.types.containsKey(t)) {
                        s = this.types.get(t);
                    } else {
                        s = new HashSet();
                        this.types.put(t, s);
                    }
                    s.add(c);
                }
            }
            catch (Exception e) {
                log.log(2, "Error loading plugin " + name, e);
            }
        }
    }

    HashSet<String> searchPlugins(File dir) {
        if (!dir.isDirectory()) {
            log.error("Error opening plugins directory.");
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        String[] files = dir.list();
        int i = 0;
        while (i < files.length) {
            if (files[i].endsWith(".class") && files[i].indexOf(36) == -1) {
                int j = files[i].indexOf(".class");
                String name = files[i].substring(0, j);
                result.add(name);
            }
            ++i;
        }
        return result;
    }

    public String getDefaultPlugin(String type) {
        return this.dh.get(type);
    }

    public String[] getPlugins(String type) {
        if (!this.types.containsKey(type)) {
            return null;
        }
        Set s = this.types.get(type);
        String[] result = new String[s.size()];
        Iterator i = s.iterator();
        int count = 0;
        while (i.hasNext()) {
            result[count++] = ((Class)i.next()).getName();
        }
        return result;
    }

    public String[] getTypes() {
        Set<String> s = this.types.keySet();
        Iterator<String> i = s.iterator();
        String[] result = new String[s.size()];
        int count = 0;
        while (i.hasNext()) {
            result[count++] = i.next();
        }
        return result;
    }

    public Plugin newHandler(String pluginName, JInternalFrame frame) {
        Class<?> c;
        try {
            c = Class.forName(pluginName);
        }
        catch (ClassNotFoundException e) {
            c = null;
        }
        try {
            if (c == null) {
                c = Class.forName("maslab.telemetry.botclient." + pluginName);
            }
            Constructor<?> con = c.getConstructor(JInternalFrame.class);
            frame.setClosable(true);
            frame.setIconifiable(true);
            Plugin p = (Plugin)con.newInstance(frame);
            return p;
        }
        catch (Exception e) {
            log.log(2, "Unable to instantiate plugin " + pluginName, e);
            return null;
        }
    }
}

