/*
 * Decompiled with CFR 0.152.
 */
package maslab.telemetry.botclient;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.CRC32;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import maslab.telemetry.StatusEvent;
import maslab.telemetry.StatusListener;
import maslab.telemetry.botclient.Plugin;
import maslab.util.Logger;

public class VectorPlugin
extends JPanel
implements Plugin,
StatusListener {
    public static String types = "vectorgraphics";
    public static Logger log = new Logger("VectorPlugin");
    JInternalFrame frame;
    HashMap<Integer, Drawable> items;
    HashSet<Drawable> grid;
    Color currentColor;
    int originX = 0;
    int originY = 0;
    int translateX = 0;
    int translateY = 0;
    double zoomfactor = 1.0;
    double zoomfactordiff = 0.0;
    public static final long serialVersionUID = 1001L;

    public VectorPlugin(JInternalFrame frame) {
        this.frame = frame;
        frame.getContentPane().add(this);
        frame.setSize(320, 240);
        frame.setResizable(true);
        frame.setVisible(true);
        this.items = new HashMap();
        this.currentColor = Color.GREEN;
        Transformer t = new Transformer();
        this.addMouseMotionListener(t);
        this.addMouseListener(t);
        this.grid = new HashSet();
        int gridlimit = 1000;
        int x = -gridlimit;
        while (x < gridlimit + 1) {
            Line l = new Line();
            l.color = Color.DARK_GRAY;
            l.x1 = x;
            l.y1 = -gridlimit;
            l.x2 = x;
            l.y2 = gridlimit;
            this.grid.add(l);
            l = new Line();
            l.color = Color.DARK_GRAY;
            l.y1 = x;
            l.x1 = -gridlimit;
            l.y2 = x;
            l.x2 = gridlimit;
            this.grid.add(l);
            x += 10;
        }
    }

    @Override
    public boolean addChannel(String name, String type) {
        this.frame.setTitle(name);
        return true;
    }

    @Override
    public void removeChannel(String name) {
    }

    @Override
    public synchronized void messageReceived(String channel, byte[] data) {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
            int msg = dis.readInt();
            switch (msg) {
                case 0: {
                    this.doLine(dis);
                    break;
                }
                case 3: {
                    this.doDelete(dis);
                    break;
                }
                case 4: {
                    this.doCircle(dis);
                    break;
                }
                case 5: {
                    this.doClear(dis);
                    break;
                }
                default: {
                    log.warn("Unknown message type: " + msg);
                    break;
                }
            }
        }
        catch (IOException ioe) {
            log.log(2, "Unexpected IOException", ioe);
        }
    }

    void doLine(DataInputStream dis) throws IOException {
        Line l = new Line();
        l.color = this.readColor(dis);
        l.x1 = dis.readInt();
        l.y1 = dis.readInt();
        l.x2 = dis.readInt();
        l.y2 = dis.readInt();
        CRC32 crc = new CRC32();
        crc.update(l.color.getRGB());
        crc.update(l.x1);
        crc.update(l.y1);
        crc.update(l.x2);
        crc.update(l.y2);
        Integer key = new Integer((int)crc.getValue());
        this.items.put(key, l);
        this.repaint();
    }

    void doCircle(DataInputStream dis) throws IOException {
        Circle l = new Circle();
        l.color = this.readColor(dis);
        l.x = dis.readInt();
        l.y = dis.readInt();
        l.r = dis.readInt();
        CRC32 crc = new CRC32();
        crc.update(l.color.getRGB());
        crc.update(l.x);
        crc.update(l.y);
        crc.update(l.r);
        Integer key = new Integer((int)crc.getValue());
        this.items.put(key, l);
        this.repaint();
    }

    Color readColor(DataInputStream dis) throws IOException {
        int r = dis.readInt();
        int g = dis.readInt();
        int b = dis.readInt();
        return new Color(r, g, b);
    }

    void doDelete(DataInputStream dis) throws IOException {
        int handle = dis.readInt();
        this.items.remove(new Integer(handle));
        this.repaint();
    }

    void doClear(DataInputStream dis) throws IOException {
        this.items.clear();
        this.repaint();
    }

    @Override
    public synchronized void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.scale(this.zoomfactor + this.zoomfactordiff, this.zoomfactor + this.zoomfactordiff);
        g.translate(this.originX + this.translateX, this.originY + this.translateY);
        for (Drawable d : this.grid) {
            d.draw(g2);
        }
        for (Drawable d : this.items.values()) {
            d.draw(g2);
        }
    }

    @Override
    public void statusChanged(StatusEvent e) {
        if (e.name.equals("connected") && e.booleanValue) {
            this.items = new HashMapBuffer<Integer, Drawable>();
            this.repaint();
        }
    }

    class Circle
    implements Drawable {
        int x;
        int y;
        int r;
        Color color;

        Circle() {
        }

        @Override
        public void draw(Graphics2D g) {
            g.setColor(this.color);
            g.drawArc(this.x - this.r, this.y - this.r, 2 * this.r, 2 * this.r, 0, 360);
        }
    }

    static interface Drawable {
        public void draw(Graphics2D var1);
    }

    class HashMapBuffer<K, V>
    extends LinkedHashMap<K, V> {
        static final int MAX_SIZE = 1024;
        static final long serialVersionUID = 1001L;

        HashMapBuffer() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 1024;
        }
    }

    class Line
    implements Drawable {
        int x1;
        int y1;
        int x2;
        int y2;
        Color color;

        Line() {
        }

        @Override
        public void draw(Graphics2D g) {
            g.setColor(this.color);
            g.drawLine(this.x1, this.y1, this.x2, this.y2);
        }
    }

    class Transformer
    extends MouseAdapter
    implements MouseMotionListener {
        int dragOriginX;
        int dragOriginY;
        boolean zmode = false;

        Transformer() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.dragOriginX = e.getX();
            this.dragOriginY = e.getY();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.zmode || (e.getModifiersEx() & 0x80) != 0) {
                VectorPlugin.this.zoomfactordiff = (double)(e.getX() - this.dragOriginX) / 200.0;
                this.zmode = true;
                VectorPlugin.this.repaint();
            } else {
                VectorPlugin.this.translateX = (int)((double)(e.getX() - this.dragOriginX) / VectorPlugin.this.zoomfactor);
                VectorPlugin.this.translateY = (int)((double)(e.getY() - this.dragOriginY) / VectorPlugin.this.zoomfactor);
                VectorPlugin.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            VectorPlugin.this.originX += VectorPlugin.this.translateX;
            VectorPlugin.this.originY += VectorPlugin.this.translateY;
            VectorPlugin.this.translateX = 0;
            VectorPlugin.this.translateY = 0;
            this.zmode = false;
            VectorPlugin.this.zoomfactor += VectorPlugin.this.zoomfactordiff;
            VectorPlugin.this.zoomfactordiff = 0.0;
            VectorPlugin.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

