/*
 * Decompiled with CFR 0.152.
 */
package maslab.telemetry.channel;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import maslab.telemetry.channel.Channel;
import maslab.util.Logger;
import orc.camera.ImageUtil;

public class ImageChannel
extends Channel {
    ByteArrayOutputStream imageBuffer;
    int downsampling = 1;
    boolean compression = false;
    Logger log = new Logger(this);

    protected void init(String name, boolean compression, int downsampling) {
        ImageChannel.assertInitialized();
        this.downsampling = downsampling;
        this.compression = false;
        this.nametype = compression ? String.valueOf(name) + "$" + "jpegimage" : String.valueOf(name) + "$" + "rawimage";
        jc.advertise(this.nametype);
        jc.setMaximumQueueSize(this.nametype, 32768);
        this.imageBuffer = new ByteArrayOutputStream();
    }

    public ImageChannel(String name) {
        this.init(name, false, 1);
    }

    public ImageChannel(String name, boolean compression) {
        this.init(name, compression, 1);
    }

    public ImageChannel(String name, boolean compression, int downsampling) {
        this.init(name, compression, downsampling);
    }

    public synchronized void publish(BufferedImage img) {
        if (!jc.publishing(this.nametype)) {
            return;
        }
        if (this.downsampling != 1) {
            img = ImageUtil.scaleImage((BufferedImage)img, (int)(img.getWidth() / this.downsampling), (int)(img.getHeight() / this.downsampling));
        }
        img = ImageUtil.convertImage((BufferedImage)img, (int)1);
        this.publishRaw(img);
    }

    void publishRaw(BufferedImage img) {
        DataBuffer db = img.getRaster().getDataBuffer();
        if (db instanceof DataBufferInt) {
            this.publishRawInt(img, (DataBufferInt)db);
        } else if (db instanceof DataBufferByte) {
            this.publishRawByte(img, (DataBufferByte)db);
        } else {
            this.log.error("Unknown image type!");
        }
    }

    void publishRawInt(BufferedImage img, DataBufferInt dbuf) {
        int[] buf = dbuf.getData();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(128 + 4 * buf.length);
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(img.getWidth());
            dos.writeInt(img.getHeight());
            dos.writeInt(3);
            dos.writeInt(this.downsampling);
            int i = 0;
            while (i < buf.length) {
                dos.writeByte(buf[i] & 0xFF);
                dos.writeByte(buf[i] >> 8 & 0xFF);
                dos.writeByte(buf[i] >> 16 & 0xFF);
                ++i;
            }
            dos.flush();
        }
        catch (IOException ioe) {
            return;
        }
        jc.publish(this.nametype, baos.toByteArray());
    }

    void publishRawByte(BufferedImage img, DataBufferByte dbuf) {
        byte[] buf = dbuf.getData();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(16 + buf.length);
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(img.getWidth());
            dos.writeInt(img.getHeight());
            dos.writeInt(3);
            dos.writeInt(this.downsampling);
            dos.write(buf);
            dos.flush();
        }
        catch (IOException ioe) {
            return;
        }
        jc.publish(this.nametype, baos.toByteArray());
    }
}

