/*
 * Decompiled with CFR 0.152.
 */
package maslab.telemetry.channel;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import maslab.telemetry.channel.Channel;
import maslab.util.Logger;

public class VectorChannel
extends Channel {
    public static Logger log = new Logger("VectorChannel");
    public static final int LINE = 0;
    public static final int DOT = 1;
    public static final int DELETE = 3;
    public static final int CIRCLE = 4;
    public static final int CLEAR = 5;
    ByteArrayOutputStream baos;
    DataOutputStream dos;
    Color currentColor;

    public VectorChannel(String name) {
        VectorChannel.assertInitialized();
        this.nametype = String.valueOf(name) + "$" + "vectorgraphics";
        jc.advertise(this.nametype);
        this.baos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.baos);
        this.currentColor = new Color(0, 255, 0);
    }

    public synchronized int drawLine(int x1, int y1, int x2, int y2) {
        block5: {
            try {
                try {
                    this.dos.writeInt(0);
                    this.writeColor(this.currentColor, this.dos);
                    this.dos.writeInt(x1);
                    this.dos.writeInt(y1);
                    this.dos.writeInt(x2);
                    this.dos.writeInt(y2);
                    jc.publish(this.nametype, this.baos.toByteArray());
                }
                catch (IOException ioe) {
                    log.log(2, "Unexpected IOException in drawLine", ioe);
                    this.baos.reset();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.baos.reset();
                throw throwable;
            }
            this.baos.reset();
        }
        CRC32 crc = new CRC32();
        crc.update(this.currentColor.getRGB());
        crc.update(x1);
        crc.update(y1);
        crc.update(x2);
        crc.update(y2);
        return (int)crc.getValue();
    }

    public synchronized void setColor(Color c) {
        this.currentColor = c;
    }

    public synchronized int drawCircle(int x, int y, int r) {
        block5: {
            try {
                try {
                    this.dos.writeInt(4);
                    this.writeColor(this.currentColor, this.dos);
                    this.dos.writeInt(x);
                    this.dos.writeInt(y);
                    this.dos.writeInt(r);
                    jc.publish(this.nametype, this.baos.toByteArray());
                }
                catch (IOException ioe) {
                    log.log(2, "Unexpected IOException in drawLine", ioe);
                    this.baos.reset();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.baos.reset();
                throw throwable;
            }
            this.baos.reset();
        }
        CRC32 crc = new CRC32();
        crc.update(this.currentColor.getRGB());
        crc.update(x);
        crc.update(y);
        crc.update(r);
        return (int)crc.getValue();
    }

    void writeColor(Color c, DataOutputStream dos) throws IOException {
        dos.writeInt(c.getRed());
        dos.writeInt(c.getGreen());
        dos.writeInt(c.getBlue());
    }

    public synchronized void delete(int handle) {
        try {
            try {
                this.dos.writeInt(3);
                this.dos.writeInt(handle);
                jc.publish(this.nametype, this.baos.toByteArray());
            }
            catch (IOException ioe) {
                log.log(2, "Unexpected IOException in delete", ioe);
                this.baos.reset();
            }
        }
        finally {
            this.baos.reset();
        }
    }

    public synchronized void clear() {
        try {
            try {
                this.dos.writeInt(5);
                jc.publish(this.nametype, this.baos.toByteArray());
            }
            catch (IOException ioe) {
                log.log(2, "Unexpected IOException in delete", ioe);
                this.baos.reset();
            }
        }
        finally {
            this.baos.reset();
        }
    }
}

