/*
 * Decompiled with CFR 0.152.
 */
package maslab.util;

import maslab.util.Logger;
import maslab.util.LoggerPublisher;
import maslab.util.StringUtil;

public class ConsoleLoggerPublisher
extends LoggerPublisher {
    @Override
    public synchronized void publish(String name, int level, String message) {
        if (this.reentry) {
            return;
        }
        this.reentry = true;
        if (this.acceptingMessage(name, level)) {
            long nowTime = System.currentTimeMillis();
            double elapsedTime = (double)(nowTime - Logger.startTime) / 1000.0;
            String levelName = Logger.levelToString(level);
            System.out.println(String.valueOf(StringUtil.padRight(name, 20, ' ')) + StringUtil.padLeft(StringUtil.formatDouble(elapsedTime, 3), 10, ' ') + " " + StringUtil.padRight(levelName, 10, ' ') + message);
        }
        this.reentry = false;
    }
}

