/*
 * Decompiled with CFR 0.152.
 */
package maslab.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import maslab.util.ConsoleLoggerPublisher;
import maslab.util.LoggerPublisher;
import maslab.util.StringUtil;

public class Logger {
    public static final int SILENT = 0;
    public static final int ERROR = 1;
    public static final int WARN = 2;
    public static final int OUTPUT = 3;
    public static final int VERBOSE = 4;
    public static final int VVERBOSE = 5;
    public static final int DEBUG = 6;
    public static final int VDEBUG = 7;
    protected String name;
    protected static ArrayList<LoggerPublisher> publishers = new ArrayList();
    public static ConsoleLoggerPublisher consolePublisher = new ConsoleLoggerPublisher();
    public static long startTime = System.currentTimeMillis();

    static {
        Logger.addPublisher(consolePublisher);
    }

    public static String levelToString(int level) {
        switch (level) {
            case 1: {
                return "ERROR";
            }
            case 2: {
                return "WARN";
            }
            case 3: {
                return "OUTPUT";
            }
            case 4: {
                return "VERBOSE";
            }
            case 5: {
                return "VVERBOSE";
            }
            case 6: {
                return "DEBUG";
            }
            case 7: {
                return "VDEBUG";
            }
        }
        return "?????";
    }

    public Logger(String name) {
        this.name = name;
    }

    public Logger(Object o) {
        this.name = Logger.getNameFromObject(o);
    }

    public static String getNameFromObject(Object o) {
        String fullName = o.getClass().getName();
        int idx = fullName.lastIndexOf(46);
        String name = idx >= 0 ? fullName.substring(idx + 1) : fullName;
        return name;
    }

    public void log(int level, String message) {
        Logger.log(this.name, level, message);
    }

    public void log(int level, String message, Exception ex) {
        Logger.log(this.name, level, message, ex);
    }

    public void error(String message, Exception ex) {
        Logger.log(this.name, 1, message, ex);
    }

    public void error(String message) {
        Logger.log(this.name, 1, message);
    }

    public void warn(String message, Exception ex) {
        Logger.log(this.name, 2, message, ex);
    }

    public void warn(String message) {
        Logger.log(this.name, 2, message);
    }

    public void output(String message) {
        Logger.log(this.name, 3, message);
    }

    public void output(String message, Exception ex) {
        Logger.log(this.name, 3, message, ex);
    }

    public void verbose(String message) {
        Logger.log(this.name, 4, message);
    }

    public void vverbose(String message) {
        Logger.log(this.name, 5, message);
    }

    public void debug(String message) {
        Logger.log(this.name, 6, message);
    }

    public void vdebug(String message) {
        Logger.log(this.name, 7, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPublisher(LoggerPublisher publisher) {
        ArrayList<LoggerPublisher> arrayList = publishers;
        synchronized (arrayList) {
            if (!publishers.contains(publisher)) {
                publishers.add(publisher);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePublisher(LoggerPublisher publisher) {
        ArrayList<LoggerPublisher> arrayList = publishers;
        synchronized (arrayList) {
            if (publishers.contains(publisher)) {
                publishers.remove(publisher);
            }
        }
    }

    public static void log(String name, int level, String message, Exception ex) {
        StringBuffer sb = new StringBuffer();
        ByteArrayOutputStream bouts = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bouts);
        ex.printStackTrace(pw);
        pw.flush();
        sb.append(message);
        sb.append("\n");
        sb.append("  Exception: ");
        String[] lines = StringUtil.split(new String(bouts.toByteArray()), "\n");
        int i = 0;
        while (i < lines.length) {
            if (i > 0) {
                sb.append("        ");
            }
            sb.append(String.valueOf(lines[i]) + "\n");
            ++i;
        }
        Logger.log(name, level, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(String name, int level, String message) {
        ArrayList<LoggerPublisher> arrayList = publishers;
        synchronized (arrayList) {
            for (LoggerPublisher publisher : publishers) {
                publisher.publish(name, level, message);
            }
        }
    }

    public static void main(String[] args) {
        Logger log = new Logger("foobar");
        try {
            Logger.throwSomething();
        }
        catch (Exception ex) {
            log.error("this is the message", ex);
        }
    }

    protected static void throwSomething() {
        Integer i;
        Integer o = i = new Integer(5);
        String s = (String)((Object)o);
    }
}

