/*
 * Decompiled with CFR 0.152.
 */
package maslab.util;

import java.util.HashMap;
import maslab.util.Logger;
import maslab.util.StringUtil;

public class LoggerPublisher {
    int globalLevelThreshold = 3;
    HashMap<String, Integer> thresholds = new HashMap();
    boolean reentry = false;

    public synchronized void publish(String name, int level, String message) {
        if (this.reentry) {
            return;
        }
        this.reentry = true;
        if (this.acceptingMessage(name, level)) {
            this.publishUnconditional(name, level, message);
        }
        this.reentry = false;
    }

    public void publishUnconditional(String name, int level, String message) {
        long nowTime = System.currentTimeMillis();
        double elapsedTime = (double)(nowTime - Logger.startTime) / 1000.0;
        String levelName = Logger.levelToString(level);
        System.out.println(String.valueOf(StringUtil.padRight(name, 20, ' ')) + StringUtil.padLeft(StringUtil.formatDouble(elapsedTime, 3), 10, ' ') + " " + StringUtil.padRight(levelName, 10, ' ') + message);
    }

    public void setGlobalLevel(int threshold) {
        this.globalLevelThreshold = threshold;
    }

    public void setLevel(String channel, int threshold) {
        this.thresholds.put(channel, new Integer(threshold));
    }

    public void setLevel(Object channelclass, int threshold) {
        String name = Logger.getNameFromObject(channelclass);
        this.setLevel(name, threshold);
    }

    protected boolean acceptingMessage(String name, int level) {
        boolean accepted = false;
        Integer i = this.thresholds.get(name);
        if (i != null) {
            if (level <= i) {
                accepted = true;
            }
        } else if (level <= this.globalLevelThreshold) {
            accepted = true;
        }
        return accepted;
    }
}

