/*
 * Decompiled with CFR 0.152.
 */
package maslab.util;

import java.util.Random;

public class MathUtil {
    static double epsilon = 1.0E-11;

    public static double mod2pi(double v) {
        int m = (int)Math.round(v / (Math.PI * 2));
        return v -= Math.PI * 2 * (double)m;
    }

    public static double mod2pi(double ref, double v) {
        int m = (int)Math.round((v - ref) / (Math.PI * 2));
        return v -= Math.PI * 2 * (double)m;
    }

    public static boolean doubleEquals(double a, double b) {
        return Math.abs(a - b) < epsilon;
    }

    public static void main(String[] args) {
        double[] vs;
        double[] dArray = vs = new double[]{5.5, 0.5, 100.0, -5.5, -0.5, -100.0};
        int n = vs.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            double w = MathUtil.mod2pi(v);
            assert (MathUtil.doubleEquals(Math.cos(w), Math.cos(v)));
            assert (MathUtil.doubleEquals(Math.sin(w), Math.sin(v)));
            assert (w <= Math.PI && w >= -Math.PI);
            ++n2;
        }
        Random r = new Random();
        int i = 0;
        while (i < 5000) {
            double v = 50.0 * r.nextGaussian();
            double win = 50.0 * r.nextGaussian();
            double w = MathUtil.mod2pi(v, win);
            assert (MathUtil.doubleEquals(Math.cos(w), Math.cos(win)));
            assert (MathUtil.doubleEquals(Math.sin(w), Math.sin(win)));
            assert (v - w <= Math.PI && v - w >= -Math.PI);
            ++i;
        }
        System.out.println("\nAll tests passed. Next assertion will fail\n");
        assert (false);
    }
}

