/*
 * Decompiled with CFR 0.152.
 */
package orc;

import java.io.DataInputStream;
import java.io.IOException;
import orc.AX12Status;
import orc.Orc;
import orc.OrcResponse;

public class AX12Servo {
    Orc orc;
    int id;
    static final int INST_PING = 1;
    static final int INST_READ_DATA = 2;
    static final int INST_WRITE_DATA = 3;
    static final int INST_REG_WRITE = 4;
    static final int INST_ACTION = 5;
    static final int INST_RESET_DATA = 6;
    static final int INST_SYNC_WRITE = 131;
    static final int ERROR_INSTRUCTION = 64;
    static final int ERROR_OVERLOAD = 32;
    static final int ERROR_CHECKSUM = 16;
    static final int ERROR_RANGE = 8;
    static final int ERROR_OVERHEAT = 4;
    static final int ERROR_ANGLE_LIMIT = 2;
    static final int ERROR_VOLTAGE = 1;

    public AX12Servo(Orc orc, int id) {
        this.orc = orc;
        this.id = id;
    }

    static byte[] makeCommand(int id, int instruction, byte[] parameters) {
        int parameterlen = parameters == null ? 0 : parameters.length;
        byte[] cmd = new byte[6 + parameterlen];
        cmd[0] = -1;
        cmd[1] = -1;
        cmd[2] = (byte)id;
        cmd[3] = (byte)(parameterlen + 2);
        cmd[4] = (byte)instruction;
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                cmd[5 + i] = parameters[i];
            }
        }
        int checksum = 0;
        for (int i = 2; i < cmd.length - 1; ++i) {
            checksum += cmd[i] & 0xFF;
        }
        cmd[5 + parameterlen] = (byte)(checksum ^ 0xFF);
        return cmd;
    }

    public boolean ping() {
        OrcResponse resp = this.orc.doCommand(16808448, AX12Servo.makeCommand(this.id, 1, null));
        resp.print();
        byte[] tmp = new byte[]{6, -1, -1, (byte)this.id, 2, 0};
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i] == resp.responseBuffer[resp.responseBufferOffset + i]) continue;
            return false;
        }
        return true;
    }

    public void setGoalDegrees(double deg, double speedfrac, double torquefrac) {
        int posv = (int)(1023.0 * deg / 300.0);
        int speedv = (int)(1023.0 * speedfrac);
        int torquev = (int)(1023.0 * torquefrac);
        OrcResponse resp = this.orc.doCommand(16808448, AX12Servo.makeCommand(this.id, 3, new byte[]{30, (byte)(posv & 0xFF), (byte)(posv >> 8), (byte)(speedv & 0xFF), (byte)(speedv >> 8), (byte)(torquev & 0xFF), (byte)(torquev >> 8)}));
        resp.print();
    }

    public AX12Status getStatus() {
        AX12Status status = new AX12Status();
        while (true) {
            OrcResponse resp = this.orc.doCommand(16808448, AX12Servo.makeCommand(this.id, 2, new byte[]{36, 8}));
            resp.print();
            DataInputStream ins = resp.ins;
            try {
                int paramlen;
                int id;
                int ff;
                int len = ins.read();
                if (len != 14 || (ff = ins.read()) != 255 || (ff = ins.read()) != 255 || (id = ins.read()) != this.id || (paramlen = ins.read()) != 10) continue;
                status.error_flags = ins.read();
                status.positionDegrees = (double)((ins.read() & 0xFF) + ((ins.read() & 0x3F) << 8)) * 300.0 / 1024.0;
                status.speed = (double)((ins.read() & 0xFF) + ((ins.read() & 0x3F) << 8)) / 1024.0;
                int iload = (ins.read() & 0xFF) + ((ins.read() & 0xFF) << 8);
                status.load = (double)(iload & 0x3FF) / 1024.0;
                if ((iload & 0x400) != 0) {
                    status.load = -status.load;
                }
                status.voltage = (double)(ins.read() & 0xFF) / 10.0;
                status.temperature = ins.read() & 0xFF;
            }
            catch (IOException ex) {
                continue;
            }
            break;
        }
        return status;
    }

    public static void main(String[] args) {
        Orc orc = Orc.makeOrc();
        AX12Servo servo = new AX12Servo(orc, 1);
        int iter = 0;
        while (true) {
            System.out.printf("%d\n", iter);
            servo.ping();
            AX12Status st = servo.getStatus();
            st.print();
            System.out.println("**");
            servo.setGoalDegrees(150.0, 0.1, 0.1);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            servo.setGoalDegrees(160.0, 0.1, 0.1);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            ++iter;
        }
    }
}

