/*
 * Decompiled with CFR 0.152.
 */
package orc;

import orc.Orc;
import orc.OrcStatus;

public class AnalogInput {
    Orc orc;
    int port;

    public AnalogInput(Orc orc, int port) {
        assert (port >= 0 && port <= 7);
        this.orc = orc;
        this.port = port;
    }

    public double getVoltage() {
        OrcStatus status = this.orc.getStatus();
        return (double)status.analogInputFiltered[this.port] / 65535.0 * 5.0;
    }

    public double getVoltageUnfiltered() {
        OrcStatus status = this.orc.getStatus();
        return (double)status.analogInput[this.port] / 65535.0 * 5.0;
    }

    public void setLPF(double alpha) {
        assert (alpha >= 0.0 && alpha <= 1.0);
        int v = (int)(alpha * 65536.0);
        this.orc.doCommand(12288, new byte[]{(byte)this.port, (byte)(v >> 8 & 0xFF), (byte)(v >> 0 & 0xFF)});
    }
}

