/*
 * Decompiled with CFR 0.152.
 */
package orc;

import orc.Orc;
import orc.OrcStatus;

public class Motor {
    Orc orc;
    int port;
    boolean invert;

    public Motor(Orc orc, int port, boolean invert) {
        this.orc = orc;
        this.port = port;
        this.invert = invert;
    }

    public void idle() {
        this.orc.doCommand(4096, new byte[]{(byte)this.port, 0, 0, 0});
    }

    public void setPWM(double v) {
        assert (v >= -1.0 && v <= 1.0);
        int pwm = (int)(v * 255.0);
        if (this.invert) {
            pwm *= -1;
        }
        this.orc.doCommand(4096, new byte[]{(byte)this.port, 1, (byte)(pwm >> 8 & 0xFF), (byte)(pwm & 0xFF)});
    }

    public void setWatchDog(int usec) {
        assert (usec >= 0);
        this.orc.doCommand(4098, new byte[]{(byte)(usec >> 24 & 0xFF), (byte)(usec >> 16 & 0xFF), (byte)(usec >> 8 & 0xFF), (byte)(usec & 0xFF)});
    }

    public double getCurrent() {
        OrcStatus status = this.orc.getStatus();
        double voltage = (double)status.analogInput[this.port + 8] / 65535.0 * 3.0;
        double current = voltage * 375.0 / 200.0;
        return current;
    }

    public void setSlewSeconds(double seconds) {
        assert (seconds >= 0.0 && seconds < 120.0);
        seconds = Math.max(seconds, 0.001);
        double dv = 0.51 / seconds * 128.0;
        int iv = (int)dv;
        iv = Math.max(iv, 1);
        iv = Math.min(iv, 65535);
        this.orc.doCommand(4097, new byte[]{(byte)this.port, (byte)(iv >> 8 & 0xFF), (byte)(iv & 0xFF)});
    }
}

