/*
 * Decompiled with CFR 0.152.
 */
package orc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import orc.spy.WeightedGridLayout;

public class OrcSetup {
    InetAddress broadcastInetAddr;
    OrcDetection selectedOrcDetection = null;
    ArrayList<OrcDetection> detections = new ArrayList();
    JFrame jf;
    HashMap<String, Param> paramsMap = new HashMap();
    JPanel paramsPanel;
    JButton revertButton = new JButton("Revert");
    JButton randomMACButton = new JButton("Randomize MAC");
    JButton writeButton = new JButton("Write to uOrc");
    JTextArea log = new JTextArea();
    MyListModel mdl = new MyListModel();
    JList orcList = new JList(this.mdl);
    ArrayList<String> orcIps = new ArrayList();
    Random rand = new Random();
    FindOrcThread finder;
    DatagramSocket sock;
    static final int FLASH_PARAM_SIGNATURE = -311321921;
    static final int FLASH_PARAM_VERSION = 2;
    static final int FLASH_PARAM_LENGTH = 37;

    public static void main(String[] args) {
        new OrcSetup();
    }

    void addParamIPAddress(String name) {
        this.paramsPanel.add(new JLabel(name));
        StringParam p = new StringParam();
        this.paramsPanel.add(p.getComponent());
        this.paramsMap.put(name, p);
    }

    void addParamMACAddress(String name) {
        this.paramsPanel.add(new JLabel(name));
        StringParam p = new StringParam();
        this.paramsPanel.add(p.getComponent());
        this.paramsMap.put(name, p);
    }

    void addParamBoolean(String name) {
        this.paramsPanel.add(new JLabel(name));
        BooleanParam p = new BooleanParam();
        this.paramsPanel.add(p.getComponent());
        this.paramsMap.put(name, p);
    }

    public OrcSetup() {
        try {
            this.broadcastInetAddr = Inet4Address.getByName("255.255.255.255");
        }
        catch (UnknownHostException ex) {
            System.out.println("ex: " + ex);
            System.exit(-1);
        }
        this.finder = new FindOrcThread();
        this.finder.start();
        this.orcList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                OrcSetup.this.listChanged();
            }
        });
        this.jf = new JFrame("OrcSetup");
        this.jf.setLayout(new BorderLayout());
        this.paramsPanel = new JPanel();
        WeightedGridLayout wgl = new WeightedGridLayout(new double[]{0.1, 0.9});
        wgl.setDefaultRowWeight(0.0);
        this.paramsPanel.setLayout(wgl);
        this.addParamIPAddress("ipaddr");
        this.addParamIPAddress("ipmask");
        this.addParamIPAddress("ipgw");
        this.addParamMACAddress("macaddr");
        this.addParamBoolean("dhcpd_enable");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.revertButton);
        buttonPanel.add(this.randomMACButton);
        buttonPanel.add(this.writeButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.paramsPanel, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        JPanel orcListPanel = new JPanel();
        orcListPanel.setLayout(new BorderLayout());
        orcListPanel.add((Component)new JLabel("uOrcs found:"), "North");
        orcListPanel.add((Component)new JScrollPane(this.orcList), "Center");
        orcListPanel.add(Box.createHorizontalStrut(10), "East");
        mainPanel.add((Component)orcListPanel, "West");
        JSplitPane jsp = new JSplitPane(0, mainPanel, new JScrollPane(this.log));
        this.jf.add((Component)jsp, "Center");
        jsp.setDividerLocation(0.65);
        jsp.setResizeWeight(0.65);
        this.revertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrcSetup.this.revert();
            }
        });
        this.randomMACButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrcSetup.this.randomMAC();
            }
        });
        this.writeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrcSetup.this.write();
            }
        });
        this.jf.setSize(600, 500);
        this.jf.setVisible(true);
        this.log.setEditable(false);
        this.log.setFont(new Font("Monospaced", 0, 12));
        this.logAppend("Started.");
        this.listChanged();
    }

    void listChanged() {
        int idx = this.orcList.getSelectedIndex();
        if (idx < 0) {
            this.paramsMap.get("ipaddr").setValue("");
            this.paramsMap.get("ipmask").setValue("");
            this.paramsMap.get("ipgw").setValue("");
            this.paramsMap.get("macaddr").setValue("");
            this.revertButton.setEnabled(false);
            this.randomMACButton.setEnabled(false);
            this.writeButton.setEnabled(false);
            return;
        }
        this.selectedOrcDetection = this.detections.get(idx);
        this.paramsMap.get("ipaddr").setValue(this.ip2string(this.selectedOrcDetection.ip4addr));
        this.paramsMap.get("ipmask").setValue(this.ip2string(this.selectedOrcDetection.ip4mask));
        this.paramsMap.get("ipgw").setValue(this.ip2string(this.selectedOrcDetection.ip4gw));
        this.paramsMap.get("macaddr").setValue(this.mac2string(this.selectedOrcDetection.macaddr));
        this.paramsMap.get("dhcpd_enable").setValue(this.boolean2string(this.selectedOrcDetection.dhcpd_enable));
        this.revertButton.setEnabled(true);
        this.randomMACButton.setEnabled(true);
        this.writeButton.setEnabled(true);
    }

    void revert() {
        this.listChanged();
    }

    void randomMAC() {
        long r = this.rand.nextLong();
        Param p = this.paramsMap.get("macaddr");
        p.setValue(String.format("%02x:%02x:%02x:%02x:%02x:%02x", 2, 0, r >> 24 & 0xFFL, r >> 16 & 0xFFL, r >> 8 & 0xFFL, r & 0xFFL));
    }

    void logAppend(String s) {
        this.log.append(s);
        this.log.setCaretPosition(this.log.getText().length() - 1);
    }

    int swap(int v) {
        return ((v >> 24 & 0xFF) << 0) + ((v >> 16 & 0xFF) << 8) + ((v >> 8 & 0xFF) << 16) + ((v & 0xFF) << 24);
    }

    long swap(long v) {
        return ((v >> 56 & 0xFFL) << 0) + ((v >> 48 & 0xFFL) << 8) + ((v >> 40 & 0xFFL) << 16) + ((v >> 32 & 0xFFL) << 24) + ((v >> 24 & 0xFFL) << 32) + ((v >> 16 & 0xFFL) << 40) + ((v >> 8 & 0xFFL) << 48) + ((v & 0xFFL) << 56);
    }

    int string2ip(String s) {
        String[] toks = s.split("\\.");
        if (toks.length != 4) {
            throw new RuntimeException("Invalid IP format");
        }
        return (Integer.parseInt(toks[0]) << 24) + (Integer.parseInt(toks[1]) << 16) + (Integer.parseInt(toks[2]) << 8) + Integer.parseInt(toks[3]);
    }

    String ip2string(int ip) {
        return String.format("%d.%d.%d.%d", ip >> 24 & 0xFF, ip >> 16 & 0xFF, ip >> 8 & 0xFF, ip & 0xFF);
    }

    long string2mac(String s) {
        String[] toks = s.split(":");
        if (toks.length != 6) {
            throw new RuntimeException("Invalid MAC address format");
        }
        return ((long)Integer.parseInt(toks[0], 16) << 40) + ((long)Integer.parseInt(toks[1], 16) << 32) + ((long)Integer.parseInt(toks[2], 16) << 24) + ((long)Integer.parseInt(toks[3], 16) << 16) + ((long)Integer.parseInt(toks[4], 16) << 8) + ((long)Integer.parseInt(toks[5], 16) << 0);
    }

    boolean string2boolean(String s) {
        s = s.toLowerCase();
        return s.equals("true");
    }

    String boolean2string(boolean b) {
        if (b) {
            return "true";
        }
        return "false";
    }

    String mac2string(long mac) {
        return String.format("%02x:%02x:%02x:%02x:%02x:%02x", mac >> 40 & 0xFFL, mac >> 32 & 0xFFL, mac >> 24 & 0xFFL, mac >> 16 & 0xFFL, mac >> 8 & 0xFFL, mac & 0xFFL);
    }

    void logArray(byte[] buf, int offset, int len) {
        for (int i = 0; i < len - offset; ++i) {
            if (i % 16 == 0) {
                this.logAppend(String.format("%04x : ", i));
            }
            this.logAppend(String.format("%02x ", buf[offset + i]));
            if (i % 16 != 15) continue;
            this.logAppend("\n");
        }
        this.logAppend("\n");
    }

    void write() {
        try {
            ByteArrayOutputStream bouts = new ByteArrayOutputStream();
            DataOutputStream outs = new DataOutputStream(bouts);
            OrcDetection od = this.detections.get(this.orcList.getSelectedIndex());
            outs.writeInt(-307579079);
            outs.writeInt(65281);
            outs.writeInt(od.bootNonce);
            outs.writeInt(128);
            outs.writeInt(this.swap(-311321921));
            outs.writeInt(this.swap(2));
            outs.writeInt(this.swap(37));
            outs.writeInt(this.swap(this.string2ip(this.paramsMap.get("ipaddr").getValue())));
            outs.writeInt(this.swap(this.string2ip(this.paramsMap.get("ipmask").getValue())));
            outs.writeInt(this.swap(this.string2ip(this.paramsMap.get("ipgw").getValue())));
            outs.writeLong(this.swap(this.string2mac(this.paramsMap.get("macaddr").getValue())));
            outs.writeByte(this.string2boolean(this.paramsMap.get("dhcpd_enable").getValue()) ? 1 : 0);
            outs.writeInt(this.swap(-311321921));
            this.logAppend("Writing parameter block...\n");
            byte[] p = bouts.toByteArray();
            System.out.println(od.addr);
            DatagramPacket packet = new DatagramPacket(p, p.length, this.broadcastInetAddr, 2379);
            this.sock.send(packet);
            this.logAppend("...finished. Reset uORC for settings to take effect.\n\n");
        }
        catch (IOException ex) {
            System.out.println("ex: " + ex);
        }
    }

    class FindOrcThread
    extends Thread {
        HashMap<Integer, OrcDetection> detectionsMap = new HashMap();
        ReaderThread reader;

        public FindOrcThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.runEx();
            }
            catch (IOException ex) {
                System.out.println("Ex: " + ex);
            }
            catch (InterruptedException ex) {
                System.out.println("Ex: " + ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runEx() throws IOException, InterruptedException {
            OrcSetup.this.sock = new DatagramSocket(2379);
            this.reader = new ReaderThread();
            this.reader.setDaemon(true);
            this.reader.start();
            while (true) {
                ByteArrayOutputStream bouts = new ByteArrayOutputStream();
                DataOutputStream outs = new DataOutputStream(bouts);
                outs.writeInt(-307579079);
                outs.writeInt(0);
                byte[] p = bouts.toByteArray();
                DatagramPacket packet = new DatagramPacket(p, p.length, OrcSetup.this.broadcastInetAddr, 2379);
                OrcSetup.this.sock.send(packet);
                Thread.sleep(500L);
                ArrayList<OrcDetection> goodDetections = new ArrayList<OrcDetection>();
                HashMap<Integer, OrcDetection> hashMap = this.detectionsMap;
                synchronized (hashMap) {
                    for (OrcDetection od : this.detectionsMap.values()) {
                        double age = (double)(System.currentTimeMillis() - od.mstime) / 1000.0;
                        if (!(age < 1.2)) continue;
                        goodDetections.add(od);
                    }
                    this.detectionsMap.clear();
                    for (OrcDetection od : goodDetections) {
                        this.detectionsMap.put(od.bootNonce, od);
                    }
                }
                Collections.sort(goodDetections);
                boolean changed = false;
                if (goodDetections.size() != OrcSetup.this.detections.size()) {
                    changed = true;
                }
                if (!changed) {
                    for (int i = 0; i < goodDetections.size(); ++i) {
                        if (goodDetections.get(i) == OrcSetup.this.detections.get(i)) continue;
                        changed = true;
                    }
                }
                if (!changed) continue;
                OrcSetup.this.detections = goodDetections;
                if (OrcSetup.this.selectedOrcDetection != null && !OrcSetup.this.detections.contains(OrcSetup.this.selectedOrcDetection)) {
                    OrcSetup.this.orcList.clearSelection();
                    OrcSetup.this.listChanged();
                }
                OrcSetup.this.mdl.changed();
            }
        }

        class ReaderThread
        extends Thread {
            ReaderThread() {
            }

            @Override
            public void run() {
                try {
                    this.runEx();
                }
                catch (IOException ex) {
                    System.out.println("Ex: " + ex);
                }
            }

            void runEx() throws IOException {
                while (true) {
                    int magic;
                    byte[] buf = new byte[1600];
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    OrcSetup.this.sock.receive(packet);
                    DataInputStream ins = new DataInputStream(new ByteArrayInputStream(buf, 0, packet.getLength()));
                    if (ins.available() < 4 || (magic = ins.readInt()) != 1968132675) continue;
                    int bootNonce = ins.readInt();
                    OrcDetection od = FindOrcThread.this.detectionsMap.get(bootNonce);
                    if (od == null) {
                        od = new OrcDetection();
                        od.bootNonce = bootNonce;
                        FindOrcThread.this.detectionsMap.put(bootNonce, od);
                    }
                    od.addr = packet.getAddress();
                    od.mstime = System.currentTimeMillis();
                    od.magic = OrcSetup.this.swap(ins.readInt());
                    od.version = OrcSetup.this.swap(ins.readInt());
                    od.length = OrcSetup.this.swap(ins.readInt());
                    od.ip4addr = OrcSetup.this.swap(ins.readInt());
                    od.ip4mask = OrcSetup.this.swap(ins.readInt());
                    od.ip4gw = OrcSetup.this.swap(ins.readInt());
                    od.macaddr = OrcSetup.this.swap(ins.readLong());
                    od.dhcpd_enable = ins.readByte() != 0;
                    od.magic2 = OrcSetup.this.swap(ins.readInt());
                }
            }
        }
    }

    class MyListModel
    implements ListModel {
        ArrayList<ListDataListener> listeners = new ArrayList();

        MyListModel() {
        }

        @Override
        public void addListDataListener(ListDataListener listener) {
            this.listeners.add(listener);
        }

        public Object getElementAt(int index) {
            OrcDetection od = OrcSetup.this.detections.get(index);
            return String.format("%08x : %s", od.bootNonce, OrcSetup.this.ip2string(od.ip4addr));
        }

        @Override
        public int getSize() {
            return OrcSetup.this.detections.size();
        }

        @Override
        public void removeListDataListener(ListDataListener listener) {
            this.listeners.remove(listener);
        }

        public void changed() {
            for (ListDataListener listener : this.listeners) {
                listener.contentsChanged(new ListDataEvent(this, 0, 0, this.getSize()));
            }
        }
    }

    class StringParam
    implements Param {
        JTextField textField = new JTextField();

        StringParam() {
        }

        @Override
        public String getValue() {
            return this.textField.getText();
        }

        @Override
        public void setValue(String v) {
            this.textField.setText(v);
        }

        @Override
        public JComponent getComponent() {
            return this.textField;
        }
    }

    class BooleanParam
    implements Param {
        JCheckBox checkBox = new JCheckBox();

        BooleanParam() {
        }

        @Override
        public String getValue() {
            return this.checkBox.isSelected() ? "true" : "false";
        }

        @Override
        public void setValue(String v) {
            this.checkBox.setSelected(v.equals("true"));
        }

        @Override
        public JComponent getComponent() {
            return this.checkBox;
        }
    }

    static interface Param {
        public String getValue();

        public void setValue(String var1);

        public JComponent getComponent();
    }

    class OrcDetection
    implements Comparable<OrcDetection> {
        InetAddress addr;
        long mstime;
        int bootNonce;
        int magic;
        int version;
        int length;
        int ip4addr;
        int ip4mask;
        int ip4gw;
        long macaddr;
        boolean dhcpd_enable;
        int magic2;

        OrcDetection() {
        }

        @Override
        public int compareTo(OrcDetection od) {
            if (od.ip4addr == this.ip4addr) {
                return od.bootNonce - this.bootNonce;
            }
            return od.ip4addr - this.ip4addr;
        }
    }
}

