/*
 * Decompiled with CFR 0.152.
 */
package orc.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class NativeLibraryLoader {
    static HashMap<String, Boolean> libraryStatus = new HashMap();

    public static boolean isNativeAvailable(String[] jarPriorities, String libraryName) {
        Boolean b = libraryStatus.get(libraryName);
        if (b != null) {
            return b;
        }
        boolean res = NativeLibraryLoader.loadLibrary(jarPriorities, libraryName);
        libraryStatus.put(libraryName, res);
        return res;
    }

    public static void requireNative(String[] jarPriorities, String libraryName) {
        if (NativeLibraryLoader.isNativeAvailable(jarPriorities, libraryName)) {
            return;
        }
        throw new RuntimeException("Native library \"" + libraryName + "\" required but not available.");
    }

    static boolean loadLibrary(String[] jarPriorities, String libraryName) {
        byte[] buf = new byte[32768];
        String cp = System.getProperty("java.class.path");
        String[] items = cp.split(":");
        Arrays.sort(items, new JarSorter(jarPriorities));
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].endsWith(".jar") || !new File(items[i]).exists()) continue;
            try {
                JarFile jf = new JarFile(items[i]);
                Enumeration<JarEntry> e = jf.entries();
                while (e.hasMoreElements()) {
                    int len;
                    JarEntry je = e.nextElement();
                    if (!je.getName().endsWith(libraryName + ".so") && !je.getName().endsWith(libraryName + ".dll")) continue;
                    BufferedInputStream ins = new BufferedInputStream(jf.getInputStream(je));
                    File tmp = File.createTempFile("jni", ".so.tmp");
                    BufferedOutputStream outs = new BufferedOutputStream(new FileOutputStream(tmp.getAbsolutePath()));
                    while ((len = ins.read(buf)) > 0) {
                        outs.write(buf, 0, len);
                    }
                    ins.close();
                    outs.close();
                    try {
                        System.load(tmp.getAbsolutePath());
                        boolean deleted = tmp.delete();
                        if (!deleted) {
                            System.out.println("NativeLibraryLoader: leaking a tmp file.");
                        }
                        return true;
                    }
                    catch (Exception ex) {
                    }
                }
                continue;
            }
            catch (IOException ioe) {
                System.out.println("Error extracting " + items[i]);
            }
        }
        return false;
    }

    static class JarSorter
    implements Comparator<String> {
        String[] priorities;

        JarSorter(String[] priorities) {
            this.priorities = priorities;
        }

        @Override
        public int compare(String a, String b) {
            return this.getPriority(a) - this.getPriority(b);
        }

        int getPriority(String s) {
            for (int i = 0; i < this.priorities.length; ++i) {
                if (!s.endsWith(this.priorities[i])) continue;
                return i;
            }
            return this.priorities.length;
        }
    }
}

