package maslab.data;

import java.io.*;

public abstract class DataEvent
{
    /** You must support an empty constructor, but that object only
     * needs to be able to factory new objects via read. */

    public abstract double getTimeStamp();
    public abstract String getEventName();
    public abstract String getChannelName();
    public abstract String getDataString();

    /** A helper function, useful for many DataEvent
     * implementations. **/
    static final double[] readDoubleArray(BufferedReader ins) throws IOException
    {
	String l;
	
	l=ins.readLine();
	if (l==null)
	    return null;
	
	String toks[]=l.split("\\s+");
	
	double[] ds=new double[toks.length];
	for (int i=0;i<toks.length;i++)
	    {
		ds[i-1]=Double.parseDouble(toks[i]);
	    }
	return ds;
    }

}
