package maslab.laser;

import maslab.util.*;
import maslab.data.*;
import maslab.geom.*;

import java.util.*;
import java.io.*;

/** Encapsulates data from a single laser scan and provides useful
 * functionality. */
public class LaserScanData extends DataEvent implements Serializable
{
    public static final long serialVersionUID=1001;

    public double[] ranges;
    public double timeStamp;
    public int channel=0;

    public ArrayList<GPoint2D> points;

    public LaserScanData()
    {
    }

    /** Create a LaserScan from the underlying raw data */
    public LaserScanData(double timeStamp, double[] ranges)
    {
	this.ranges=ranges;
	this.timeStamp=timeStamp;

	makePoints();
    }

    public LaserScanData(double timeStamp, String channelName, String data)
    {
	this.timeStamp=timeStamp;
	
	String[] datas=data.split("\\s+");
	ranges=new double[datas.length];
	for (int i=0;i<ranges.length;i++)
	    ranges[i]=Double.parseDouble(datas[i]);

	makePoints();
    }

    public double getTimeStamp()
    {
	return timeStamp;
    }

    public String getEventName()
    {
	return "LASER";
    }

    public String getChannelName()
    {
	return ""+channel;
    }

    public ArrayList<GPoint2D> getPoints()
    {
	return points;
    }

    public String getDataString()
    {
	StringBuffer sb=new StringBuffer();

	for (int i=0;i<ranges.length;i++)
	    {
		sb.append(StringUtil.formatDouble(ranges[i],3));
		if (i<(ranges.length-1))
		    sb.append(" ");
	    }

	return sb.toString();
    }

    /** Convert the dataevent's range measurements into xs and ys */
    protected void makePoints()
    {
	points=new ArrayList<GPoint2D>(ranges.length);

	double theta=-Math.PI/2;
	double dtheta=Math.PI/(ranges.length-1);

	for (int i=0;i<ranges.length;i++)
	    {
		if (ranges[i]<=25.0)
		    {
			points.add(new GPoint2D(ranges[i]*Math.cos(theta),
						ranges[i]*Math.sin(theta)));
		    }
		theta+=dtheta;
	    }
    }
}
