package maslab.orc;

import java.net.*;
import java.io.*;
import java.awt.image.*;
import java.awt.*;
import java.awt.color.ColorSpace;
import java.util.*;
import java.util.concurrent.*;

import maslab.util.*;

/** A simple application for collecting data from IR range finders so
 * that the parameters of their distance-fitting function can be
 * computed.
 *
 * This program uses three arguments:
 * The minimum distance to test,
 * the maximum distance to test,
 * and the distance increment.
 *
 *
 * e.g., IRCalibrate 0.1 1.5 0.2 will begin at 0.1 meters,
 * incrementing by 0.2 meters until a distance of 1.5 meters.
 *
 * The resulting table of values can be saved to a file and processed
 * in matlab.
 *
 **/
public class IRCalibrate
{
    public static void main(String[] args)
    {
	Orc orc;

	try {
	    orc=new Orc();
	} catch (Exception ex) {
	    System.out.println("Couldn't create orc.");
	    return;
	}

	double low=Double.parseDouble(args[0]);
	double high=Double.parseDouble(args[1]);
	double step=Double.parseDouble(args[2]);

	BufferedInputStream ins=new BufferedInputStream(System.in);

	double dist[];
	double volt[];

	int size=(int) ((high-low)/step+1);
	dist=new double[size];
	volt=new double[size];

	int i=0;

	for (double d=low;d<=high;d+=step)
	    {
		System.out.println("Position to "+d+"cm");
		try {
		    ins.read();
		} catch (Exception ex) {
		}

		double v=orc.analogRead(8);
		System.out.println(""+d+"cm -> "+v);

		dist[i]=d;
		volt[i]=v;
		i++;
	    }

	for ( i=0;i<size;i++)
	    {
		System.out.println(""+dist[i]+" "+volt[i]);
	    }
    }
}
