package maslab.orc;

/** Orc wrapper for ultrasound range sensors. **/
public class UltrasoundRangeSensor implements RangeSensor
{
    Orc orc;
    int port;

    public double rangeVariance=0.002;
    public double arcAngle=0.52; // roughly 30 degrees

    public UltrasoundRangeSensor(Orc orc, int port)
    {
	this.orc=orc;
	this.port=port;

	orc.pinModeWrite(port, Orc.PinMode.SONAR_PING);
	orc.pinModeWrite(port+1, Orc.PinMode.SONAR_ECHO);
    }

    public double getRange()
    {
	orc.ultrasoundPing(port);

	double d;
	while ((d=orc.ultrasoundRange(port))==0);

	return d;
    }

    public double getRangeUncertainty()
    {
	return rangeVariance;
    }

    public double getArcAngle()
    {
	return arcAngle;
    }
}

