package maslab.orcspy;

import maslab.util.*;
import maslab.orc.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;

public class OrcSpy 
{
    GetOpt opts=new GetOpt();
    Logger log=new Logger(this);

    JFrame frame;
    JLoggerPublisher jloggerPublisher;

    Canvas canv;

    PinPanel[]   pins;
    MotorPanel[] motors;

    PadPanel    padpanel;

    GyroPanel   gyropanel;

    Box port0box, port1box, port2box;

    Orc orc;
    
    SmallButton  allStopButton=new SmallButton("All Stop");

    public void doHelp()
    {
        if (opts.getReason()!=null)
            System.out.println("Invocation error: "+opts.getReason());
	
        System.out.println("\nUsage: "+this.getClass().getName()+
			   " [options]\n");
        opts.doHelp();
        System.out.println("\n");
    }


    public static void main(String[] args)
    {
        OrcSpy app;
        
        boolean forcequit=true;

	GetOpt opt = new GetOpt();
	opt.addBoolean('h',"help",false,"See this help");
	if (!opt.parse(args) || opt.getBoolean("help"))
	    {
		opt.doHelp();
		return;
	    }

	ArrayList<String> extraArgs=opt.getExtraArgs();

	Orc  orc;
        try {
	    if (extraArgs.size()==0)
		orc=new Orc();
	    else
		orc=new Orc(extraArgs.get(0));

	    app=new OrcSpy(orc);

            forcequit=app.run(args);
        } catch (Exception ex) {
	    Logger l=new Logger("OrcSpy Startup");
            l.error("Uncaught exception ",ex);
        }

        if (forcequit)
            System.exit(0);
    }

    public OrcSpy(Orc orc)
    {
	this.orc=orc;

	frame=new JFrame(this.getClass().getName());
	frame.setSize(1000,700);

	jloggerPublisher=new JLoggerPublisher();
	jloggerPublisher.setPreferredSize(new Dimension(100,70));

	Container me=frame.getContentPane();

	//////////// PINS //////////
	pins=new PinPanel[20];

	ArrayList<EnumSet<Orc.PinMode>> modesets=new ArrayList<EnumSet<Orc.PinMode>>();
	
	for (int i=0;i<20;i++)
	    {
		modesets.add(i,EnumSet.of(Orc.PinMode.DIGITAL_IN));

		modesets.get(i).add(Orc.PinMode.DIGITAL_IN);
		modesets.get(i).add(Orc.PinMode.DIGITAL_IN_PULLUP);
		modesets.get(i).add(Orc.PinMode.DIGITAL_IN_PULLDOWN);
		modesets.get(i).add(Orc.PinMode.DIGITAL_OUT);
	    }

	for (int i=0;i<4;i++)
	    modesets.get(i).add(Orc.PinMode.SERVO);
	
	for (int i=8;i<16;i++)
	    modesets.get(i).add(Orc.PinMode.ANALOG_IN);

	modesets.get(0).add(Orc.PinMode.ANALOG_IN);
	modesets.get(3).add(Orc.PinMode.ANALOG_IN);
	modesets.get(16).add(Orc.PinMode.ANALOG_IN);
	modesets.get(19).add(Orc.PinMode.ANALOG_IN);

	modesets.get(4).add(Orc.PinMode.SONAR_PING);
	modesets.get(5).add(Orc.PinMode.SONAR_ECHO);
	modesets.get(6).add(Orc.PinMode.SONAR_PING);
	modesets.get(7).add(Orc.PinMode.SONAR_ECHO);

	modesets.get(12).add(Orc.PinMode.ANALOG_OUT);
	modesets.get(14).add(Orc.PinMode.PWM);

	for (int i=16;i<20;i++)
	    {
		modesets.get(i).add(Orc.PinMode.QUADPHASE);
		modesets.get(i).add(Orc.PinMode.QUADPHASEFAST);
	    }

	modesets.get(16).add(Orc.PinMode.MONOPHASE);
	modesets.get(18).add(Orc.PinMode.MONOPHASE);

	for (int i=0;i<20;i++)
	    {
		pins[i]=new PinPanel(orc, i, modesets.get(i));
	    }

	JPanel ports=new JPanel(new GridBagLayout());
	GridBagConstraints gbc=new GridBagConstraints();
	gbc.weightx=1;	gbc.weighty=1;
	gbc.insets=new Insets(3,3,3,3);
	gbc.anchor=GridBagConstraints.NORTHWEST; gbc.fill=GridBagConstraints.BOTH;
	gbc.gridx=0; gbc.gridy=0; 

	for (int i=0;i<20;i++)
	    {
		gbc.gridx=0+i/4;	gbc.gridy=i%4;
		ports.add(pins[i],gbc);
	    }


	////////////// MOTORS //////////////
	gbc.weightx=1;	gbc.weighty=1;
	gbc.insets=new Insets(3,3,3,3);
	gbc.anchor=GridBagConstraints.NORTHWEST; gbc.fill=GridBagConstraints.BOTH;
	gbc.gridx=0; gbc.gridy=0; 

	motors=new MotorPanel[4];
	for (int i=0;i<4;i++)
	    {
		motors[i]=new MotorPanel(orc, i);

		gbc.gridx=5;            gbc.gridy=i;
		ports.add(motors[i], gbc);
	    }

	//////////// PAD /////////////////
	padpanel=new PadPanel(orc);
	gbc.gridx=0; gbc.gridwidth=3; gbc.gridy=4; gbc.gridheight=1;
	ports.add(padpanel, gbc);

	//////////// GYRO /////////////////
	gyropanel=new GyroPanel(orc);
	gbc.gridx=3; gbc.gridwidth=2; gbc.gridy=4; gbc.gridheight=1;
	ports.add(gyropanel, gbc);


	gbc.gridx=5; gbc.gridy=4; gbc.gridwidth=1; gbc.gridheight=1;
	gbc.anchor=GridBagConstraints.NORTH; gbc.fill=GridBagConstraints.HORIZONTAL;

	ports.add(allStopButton, gbc);	
	allStopButton.addActionListener(new AllStopActionListener());

	///////////// Create the rest //////////
	JSplitPane jsp=new JSplitPane(JSplitPane.VERTICAL_SPLIT, ports, jloggerPublisher);
	jsp.setDividerLocation(0.9);
	jsp.setResizeWeight(0.9);
	
	me.add(jsp, BorderLayout.CENTER);

	frame.addWindowListener(new MyWindowListener());
    }

    class MyWindowListener extends WindowAdapter
    {
	public void windowClosing(WindowEvent e)
	{
	    System.exit(0);
	}
    }

    public boolean run(String[] args) throws Exception
    {
        opts.addBoolean('h',"help",false,
                        "Show this help");

        if (!opts.parse(args) || opts.getBoolean("help"))
            {
		System.out.println("Usage: java -jar maslab.jar <IPAddress>\n");
                doHelp();
                return true;
            }

	frame.setVisible(true);
	frame.setMinimumSize(new Dimension(400,300));

	log.output("Started...");

	return false;
    }

    public class AllStopActionListener implements ActionListener
    {
	public void actionPerformed(ActionEvent e)
	{
	    orc.allStop();
	}
    }

    /*
    class UpdateThread extends Thread
    {
	public UpdateThread()
	{
	    setDaemon(true);
	}

	public void run()
	{
	    while(true)
		{
		    for (int i=0;i<20;i++)
			pins[i].update(orc);

		    for (int i=0;i<4;i++)
			motors[i].update(orc);

		    try {
			Thread.sleep(60);
		    } catch (InterruptedException ex) {
		    }
		}
	}
    }
    */
} 

