package maslab.orcspy;

import maslab.util.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;

public class PinCanvas extends JPanel
{
    public static final long serialVersionUID=1001;

    class Sample
    {
	Color[] c;
	float[] v;
	int     seqno;
    }

    LinkedList<Sample> samples;

    int MAXIMUMHISTORY=300;
    int VERTICALBARSPACING=50;

    int nextseqno=0;

    public PinCanvas()
    {
	samples=new LinkedList<Sample>();
    }

    public synchronized void paint(Graphics g)
    {
	int width=getWidth();
	int height=getHeight();

	g.setColor(Color.black);
	g.fillRect(0,0,width,height);

	int x=width-1;

	for (Sample s: samples)
	    {
		if (s.seqno%VERTICALBARSPACING==0)
		    {
			g.setColor(Color.darkGray);
			g.drawLine(x, 0, x, height);
		    }

		for (int i=0;i<s.c.length;i++)
		    {
			float v=s.v[i];

			g.setColor(s.c[i]);
			int y=(int) (height-v*height);
			if (y<0)
			    y=0;
			if (y>=height)
			    y=height-1;

			g.drawLine(x, y, x, y);
		    }

		x--;
		if (x<0)
		    break;
	    }
    }

    // A list of Colors and floats, e.g., c1, f1, c2, f2, ...
    public synchronized void addData(Object... args)
    {
	Sample s=new Sample();
	s.c=new Color[args.length/2];
	s.v=new float[args.length/2];
	s.seqno=nextseqno++;
	if (nextseqno%VERTICALBARSPACING==0)
	    nextseqno=0;

	for (int i=0;i<args.length;i+=2)
	    {
		s.c[i]=(Color) args[i];
		s.v[i]=(Float) args[i+1];
	    }
	samples.addFirst(s);
	repaint();

	if (samples.size()>MAXIMUMHISTORY)
	    samples.removeLast();
    }
}
