package maslab.orcspy;

import maslab.util.*;
import maslab.orc.*;

import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;


class PopupMenuButton extends JPanel
{
    int WIDTH=10, HEIGHT=10;
    public static final long serialVersionUID=1001;

    boolean pressed=false;
    JPopupMenu menu;

    Color interiorColor;

    public PopupMenuButton(JPopupMenu menu, Color ic)
    {
	this.interiorColor=ic;
	this.menu=menu;
	addMouseListener(new MyMouseListener());
	menu.addPopupMenuListener(new MyMenuListener());
    }

    public Dimension getMinimumSize()
    {
	return new Dimension(WIDTH, HEIGHT);
    }

    public Dimension getMaximumSize()
    {
	return getMinimumSize();
    }

    public Dimension getPreferredSize()
    {
	return getMinimumSize();
    }

    public void paint(Graphics g)
    {
	int width=getWidth();
	int height=getHeight();

	g.setColor(getParent().getBackground());
	g.fillRect(0,0,width,height);
	    
	Polygon p=new Polygon(new int[] {0, 0, width}, new int[] {0, height, height/2}, 3);
	if (pressed)
	    g.setColor(interiorColor.darker());
	else
	    g.setColor(interiorColor);
	g.fillPolygon(p);

	g.setColor(Color.black);
	g.drawPolygon(p);
    }

    class MyMouseListener extends MouseAdapter
    {
	public void mousePressed(MouseEvent e)
	{
	    menu.show(PopupMenuButton.this, getWidth(), 0);
	    //	    pressed=true;
	    //	    repaint();
	}
	public void mouseReleased(MouseEvent e)
	{
	    //	    pressed=false;
	    //	    repaint();
	}
    }

    class MyMenuListener implements PopupMenuListener
    {
	public void popupMenuCanceled(PopupMenuEvent e)
	{
	    pressed=false;
	    repaint();
	}
	public void popupMenuWillBecomeInvisible(PopupMenuEvent e)
	{
	    pressed=false;
	    repaint();
	}
	public void popupMenuWillBecomeVisible(PopupMenuEvent e)
	{
	    pressed=true;
	    repaint();
	}
    }
}
