package maslab.telemetry;

import java.util.*;

/** A simple queue useful for transferring data from one thread to
 * another in a safe way. **/
public class MTQueue<T>
{
    LinkedList<T> list;

    /** Create a new queue. **/
    public MTQueue()
    {
	list=new LinkedList<T>();
    }

    /** Put a new object in the end of the queue. 
    * @param o The object to enqueue.
    **/
    public synchronized void put(T o)
    {
	list.addLast(o);
	this.notify();
    }

    /** Get the oldest object in the queue, waiting until an object is
     * available if necessary. 
     * @return The oldest object in the queue.
     **/
    public synchronized T getBlock()
    {
	while (list.size()==0)
	    {
		try 
		    {
			this.wait();
		    }
		catch (InterruptedException ex)
		    {}
	    }

	return list.removeFirst();
    }

    /** Get the oldest object in the queue, returning null if the
     * queue is empty.
     * @return The oldest object in the queue.
     **/
    public synchronized T getPoll()
    {
	if (list.size()==0)
	    return null;

	return list.removeFirst();
    }

    /** Return a list-view of this queue. For thread safety, you must
     * synchronize on the MTQueue object for the entire time that you
     * operate on the underlying list.
     **/
    public List<T> getList()
    {
	return list;
    }

    public synchronized int size()
    {
	return list.size();
    }
}
