package maslab.telemetry.botclient;

import javax.swing.*;
import java.awt.*;
import java.awt.image.*;
import javax.imageio.*;
import java.io.*;
import java.util.*;

public class HueSaturationPlot extends JPanel
{
    BufferedImage wheel;
    int wheelRadius;
    int pointSize;
    HashSet<Point> points;

    static final long serialVersionUID = 1001;

    public HueSaturationPlot(int wheelRadius,int pointSize)
    {
	this.wheelRadius = wheelRadius;
	this.pointSize = pointSize;

	wheel = generateColorWheel(wheelRadius);
	setSize(wheelRadius*2,wheelRadius*2);
	setPreferredSize(new Dimension(wheelRadius*2,wheelRadius*2));
	points = new HashSet<Point>();
    }

    public static void main(String[] args)
    {
	JFrame foo = new JFrame();
	//foo.setSize(300,300);
	HueSaturationPlot hsp = new HueSaturationPlot(150,3);
	foo.getContentPane().add(hsp);
	foo.pack();
	foo.setVisible(true);
	hsp.plotPoint(Color.RED);
	hsp.plotPoint(Color.BLUE);
	hsp.plotPoint(Color.WHITE);
    }

    public void paint(Graphics g)
    {
	g.drawImage(wheel,0,0,getWidth(),getHeight(),0,0,getWidth(),getHeight(),null);

	Iterator i = points.iterator();
	while (i.hasNext())
	    {
		Point p = (Point)i.next();
		int x = (int)(p.saturation * wheelRadius * Math.cos(p.hue*2*Math.PI)) + wheelRadius;
		int y = (int)(p.saturation * wheelRadius * Math.sin(p.hue*2*Math.PI)) + wheelRadius;
		g.setColor(Color.WHITE);
		g.fillOval(x-pointSize,y-pointSize,pointSize*2, pointSize*2);
		g.setColor(Color.BLACK);
		g.drawOval(x-pointSize,y-pointSize,pointSize*2, pointSize*2);
	    }
    }

    BufferedImage generateColorWheel(int radius)
    {
	BufferedImage wheel = new BufferedImage(radius*2,radius*2,BufferedImage.TYPE_INT_RGB);

	Graphics g = wheel.getGraphics();
	int[] dout = new int[radius*radius*4];
	int index = 0;
	for (int y = -radius; y<radius; y++)
	    for (int x = -radius; x<radius; x++)
		{
		    double saturation = Math.sqrt(x*x+y*y)/radius;
		    double hue = (Math.atan2(y,x))/(2*Math.PI);
		    double value;
		    if (saturation > 1)
			value = 0;
		    else
			value = 1;

		    dout[index++] = Color.HSBtoRGB((float)hue,(float)saturation,(float)value);
		}
	wheel.setRGB(0,0,2*radius,2*radius,dout,0,2*radius);
	return wheel;
    }


    public void plotPoint(Color c)
    {
	float[] hsv = Color.RGBtoHSB(c.getRed(),c.getGreen(),c.getBlue(),null);
	points.add(new Point(hsv[0],hsv[1]));
	repaint();
    }

    class Point
    {
	public Point(float h, float s)
	{
	    hue = h;
	    saturation = s;
	}

	public float hue;
	public float saturation;
    }

}
