package maslab.telemetry.botclient;

import maslab.telemetry.channel.*;
import maslab.util.*;
import maslab.telemetry.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;
import java.util.*;
import java.util.zip.*;
import java.text.*;

public class ScopePlugin extends JPanel implements Plugin, StatusListener
{
    public static String types = "scope";
    public static Logger log = new Logger("ScopePlugin");

    static final long serialVersionUID = 1001;
    
    JInternalFrame frame;
    ArrayList<Point> points;
    Color currentColor;

    //Origin is top left
    double originX = 0;
    double originY = 175;

    //These are used during scrolling
    int translateX = 0;
    int translateY = 0;

    double voltsPerPixel = -10;
    double msPerPixel = 50;

    boolean resync = true;
    long starttime;

    Scroller scroller;
    DecimalFormat formatter = new DecimalFormat();

    int xcursor = 0;
    int ycursor = 0;
    

    public ScopePlugin(JInternalFrame frame)
    {
	this.frame = frame;

	GridBagLayout gb2 = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();

	frame.getContentPane().setLayout(gb2);
	
	Container con=frame.getContentPane();

	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 0;
	c.gridy = 0;
	c.weightx = 10;
	c.weighty = 10;
	c.ipadx = 0;
	c.ipady = 0;
	c.fill = GridBagConstraints.BOTH;
	c.anchor = GridBagConstraints.CENTER;
	con.add(this,c);


	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 0;
	c.gridy = 1;
	c.weightx = 10;
	c.weighty = 10;
	c.ipadx = 0;
	c.ipady = 0;
	c.fill = GridBagConstraints.BOTH;
	c.anchor = GridBagConstraints.CENTER;
	con.add(new BottomPanel(),c);


	setPreferredSize(new Dimension(500,350));
	frame.setResizable(true);
	
	frame.pack();
	frame.setVisible(true);
	points = new ArrayList<Point>();
	currentColor = Color.GREEN;
	Transformer t = new Transformer();
	addMouseMotionListener(t);
	addMouseListener(t);
	formatter.setMaximumFractionDigits(1);
	formatter.setMinimumFractionDigits(1);

    }


    public boolean addChannel(String name,String type)
    {
	frame.setTitle(name);
	return true;
    }

    public void removeChannel(String name)
    {

     }

     public synchronized void messageReceived(String channel, byte[] data)
     {
	 try{
	     DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
	     Point p = new Point();
	     if (resync)
		 {
		     resync = false;
		     starttime = dis.readLong();
		     p.ms = 0;
		     originX = getWidth();
		     scroller = new Scroller();
		     scroller.start();
		 }
	     else
		 {
		     p.ms = dis.readLong() - starttime;
		 }
	     p.volts = dis.readDouble();
	     points.add(p);
	     repaint();

	 }
	 catch(IOException ioe){
	     log.log(Logger.WARN,"Unexpected IOException",ioe);
	 }
     }

     public synchronized void paint(Graphics g)
     {
	 Graphics2D g2 = (Graphics2D)g;
	 g.setColor(Color.BLACK);
	 g.fillRect(0,0,getWidth(),getHeight());

	 g.setColor(Color.BLUE);
	 g.drawLine(xcursor,-1000,xcursor,1000);
	 g.drawLine(-1000,ycursor,1000,ycursor);


	 g.setColor(currentColor);
	 double xp = msPerPixel*(xcursor - originX)/1000.0;
	 double yp = voltsPerPixel*(ycursor - originY);
	 String xs = formatter.format(xp);
	 String ys = formatter.format(yp);
	 g.drawString(xs + "sec   " + ys,0,getHeight()-5);


	 //g2.scale(1/msPerPixel,1/voltsPerPixel);
	 g.translate((int)originX+translateX,(int)originY+translateY);

	 Iterator i = points.iterator();
	 int x = 0; int y = 0;
	 int newx, newy;
	 boolean first = true;
	 while (i.hasNext())
	     {
		 Point p = (Point)i.next();
		 newx = (int)(p.ms/msPerPixel);
		 newy = (int)(p.volts/voltsPerPixel);
		 if (first)
		     first = false;
		 else
		     g.drawLine(x,y,newx,newy);
		 x = newx;
		 y = newy;
	     }


     }


     public void statusChanged(StatusEvent e)
     {
	 if (e.name.equals("connected"))
	     {
		 if (e.booleanValue == true)
		     {
			 points = new ArrayList<Point>();
			 resync = true;
			 repaint();
		     }
		 else
		     {
			 scroller.off();
		     }
	     }
     }


    class Point
    {
	double ms,volts;
    }
    

     class Transformer extends MouseAdapter implements MouseMotionListener
     {
	 int dragOriginX, dragOriginY;


	 public void mousePressed(MouseEvent e)
	 {
	     dragOriginX = e.getX();
	     dragOriginY = e.getY();
	 }


	 public void mouseClicked(MouseEvent e)
	 {
	     if (scroller.on)
		 scroller.off();
	     else
		 {
		     scroller = new Scroller();
		     scroller.start();
		 }
	 }

	 public void mouseDragged(MouseEvent e)
	 {
	     translateX = (int)((e.getX() - dragOriginX));
	     translateY = (int)((e.getY() - dragOriginY));
	     repaint();
	     
	}

	public void mouseReleased(MouseEvent e)
	{
	    originX += translateX;
	    originY += translateY;
	    translateX = 0;
	    translateY = 0;



	    repaint();
	}

	public void mouseMoved(MouseEvent e)
	{
	    xcursor = (int)(e.getX());
	    ycursor = (int)(e.getY());
	    repaint();
	}
    }



    class Scroller extends Thread
    {
	boolean on = false;
	double msPerTick = 33.3;
	Date last;


	public void run()
	{
	    on = true;
	    double pixelsPerTick;
	    last = new Date();
	    while (on)
		{
		    try{
			Thread.sleep((int)msPerTick);
		    }
		    catch(InterruptedException ie){
		    }
			
		    Date now = new Date();
		    long ms = now.getTime() - last.getTime();
		    
		    pixelsPerTick = ms/msPerPixel;

		    if (pixelsPerTick != 0)
			{
			    originX -= pixelsPerTick;
			    last = now;
			    repaint();
			
			}
		}

	}

	void off()
	{
	    on = false;
	}

    }


    class BottomPanel extends JPanel implements ActionListener
    {
	JTextField xscale,yscale;
	static final long serialVersionUID = 1001;

	public BottomPanel()
	{
	    xscale = new JTextField(6);
	    xscale.setText(String.valueOf(msPerPixel));
	    yscale = new JTextField(6);
	    yscale.setText(String.valueOf(-voltsPerPixel));

	    add(new JLabel("ms per pixel:"));
	    add(xscale);
	    add(new JLabel("units per pixel:"));
	    add(yscale);

	    xscale.addActionListener(this);
	    yscale.addActionListener(this);
	    
	}


	public void actionPerformed(ActionEvent e)
	{
	    double oldXmax = (-originX + getWidth())*msPerPixel;
	    voltsPerPixel = -Double.valueOf(yscale.getText()).doubleValue();
	    msPerPixel = Double.valueOf(xscale.getText()).doubleValue();
	    originX = -oldXmax/msPerPixel + getWidth();
	}
	
	
    }

}
