package maslab.telemetry.botclient;


import javax.swing.*;
import java.util.*;
import maslab.telemetry.botclient.Plugin;

public class TextPlugin implements Plugin
{
    JInternalFrame frame;
    JTextArea text;
    JScrollBar scroll;
    HashSet<String> channels;

    public static final String types = "text";

    public TextPlugin(JInternalFrame frame)
    {
	channels = new HashSet<String>();

	this.frame = frame;
	text = new JTextArea();
	text.setEditable(false);
	frame.setResizable(true);

	JScrollPane sp = new JScrollPane(text);
	scroll = sp.getVerticalScrollBar();
	frame.getContentPane().add(sp);
	frame.setSize(400,400);
	frame.setVisible(true);

    }

    public void messageReceived(String name, byte[] data)
    {
	String s = new String(data);
	text.append(s);
	scroll.setValue(scroll.getMaximum());
    }

    public boolean addChannel(String name, String type)
    {
	channels.add(name);
	retitle();
	return true;
    }

    public void removeChannel(String name)
    {
	channels.remove(name);
	retitle();
    }

    void retitle()
    {
	String title = "";
	Iterator i = channels.iterator();
	while (i.hasNext())
	    {
		String name = (String)i.next();
		title = title + name + " ";
	    }
	frame.setTitle(title);
    }

}
