package maslab.test;

import maslab.camera.*;
import maslab.telemetry.channel.*;
import maslab.telemetry.*;
import maslab.util.*;

import java.awt.*;
import java.awt.image.*;
import java.io.*;
import javax.imageio.*;

public class ColorTest
{
    Logger log = new Logger(this);

    ImageChannel  camChannel = new ImageChannel("Camera");
    ImageChannel  pngChannel = new ImageChannel("PNG Image");
    ImageChannel  jpgChannel = new ImageChannel("JPG Image");

    // The logger channel registers a LoggerPublisher to display Log
    // messages on botclient.
    JugLoggerPublisher logPublisher = new JugLoggerPublisher("LogMessage");

    Camera cam;

    public static void main(String[] args)
    {
	ColorTest app = new ColorTest();

	app.run();
    }

    public ColorTest()
    {
	try {
	    cam = new Camera();
	} catch (Exception ex) {
	    System.out.println("Couldn't connect to camera: "+ex);
	    return;
	}

	logPublisher.setLevel("TeleDemo", Logger.VERBOSE);
	logPublisher.setGlobalLevel(Logger.WARN);
    }

    public void run()
    {
	while(true)
	    {
		BufferedImage b = cam.capture();
		System.out.println("Cam type: "+b.getType());

		b.setRGB(0,0,Color.red.getRGB());

		System.out.println(String.format("Red:   %8X",Color.red.getRGB()));
		System.out.println(String.format("Green: %8X",Color.green.getRGB()));
		System.out.println(String.format("blue:  %8X",Color.blue.getRGB()));

		camChannel.publish(b);

		try {
		    ImageIO.write(b, "png", new File("/tmp/foo.png"));
		    ImageIO.write(b, "jpg", new File("/tmp/foo.jpg"));
		    
		    BufferedImage png=ImageIO.read(new File("/tmp/foo.png"));
		    BufferedImage jpg=ImageIO.read(new File("/tmp/foo.jpg"));
		    
		    System.out.println("PNG type: "+png.getType());
		    System.out.println("JPG type: "+jpg.getType());

		    pngChannel.publish(png);
		    jpgChannel.publish(jpg);
	
		} catch (IOException ex) {
		    log.error("Ack", ex);
		}

		try{
		    Thread.sleep(100);
		} catch(InterruptedException ex) {}
		
	    }
    }

}
