package maslab.util;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;

/** A simple publisher for the Logger class that displays to a Swing
 * text area. Messages are filtered by a global level threshold and a
 * per-channel level threshold. If the message meets either criterion,
 * the message is published.
 **/
public class JLoggerPublisher extends JScrollPane 
{
    final static long serialVersionUID=1001;

    int globalLevelThreshold;
    HashMap<String,Integer> thresholds=new HashMap<String,Integer>();
    JTextArea textArea=new JTextArea();
    boolean tailing=true; // are we scrolling as we display new text?

    LoggerPublisher logPublisher=new LoggerPublisher();

    /** Create a new publisher with a default threshold of verbose. **/
    public JLoggerPublisher()
    {
	this.globalLevelThreshold=Logger.VERBOSE;
	Logger.addPublisher(logPublisher);
	textArea.setEditable(false);
	textArea.setRows(4);
	textArea.setFont(new Font("Monospaced",Font.PLAIN,10));
	//	textArea.setColumns(80);
	setViewportView(textArea);
    }

    class MyLoggerPublisher
    {
	public void publishUnconditional(String name, int level, String message)
	{
	    long nowTime=System.currentTimeMillis();
	    double elapsedTime=(nowTime-Logger.startTime)/1000.0;
	    String levelName=Logger.levelToString(level);
	    
	    textArea.append(StringUtil.padRight(name,16,' ') + 
			    StringUtil.padLeft(StringUtil.formatDouble(elapsedTime,3),10,' ') + " " +
			    StringUtil.padRight(levelName,10,' ') +
			    message + "\n");
	    
	    //	    if (tailing)
	    //		vScroll.setValue(vScroll.getMaximum());
	}
    }

}
