package maslab.util;

import java.util.*;

/** Useful math utilities. **/
public class MathUtil
{
    static double epsilon=0.00000000001;

    /** Ensure that v is [-PI, PI] **/
    static public double mod2pi(double v)
    {
	int m=(int) Math.round(v/(2*Math.PI));

	v-=2*Math.PI*m;

	return v;
    }

    /** Returns a value of v wrapped such that ref and v differ by no
     * more +/-PI
     **/
    static public double mod2pi(double ref, double v)
    {
	int m=(int) Math.round((v-ref)/(2*Math.PI));
	
	v-=2*Math.PI*m;

	return v;
    }

    /** Returns true if the two doubles are within a small epsilon of
     * each other. 
     **/
    static public boolean doubleEquals(double a, double b)
    {
	return Math.abs(a-b)<epsilon;
    }

    public static void main(String[] args)
    {
	double[] vs={5.5, 0.5, 100, -5.5, -.5, -100};

	for (double v : vs)
	    {
		double w=mod2pi(v);
	
		assert(doubleEquals(Math.cos(w),Math.cos(v)));
		assert(doubleEquals(Math.sin(w),Math.sin(v)));
		assert(w<=Math.PI && w>=-Math.PI);
	    }

	Random r=new Random();

	for (int i=0;i<5000;i++)
	    {
		double v=50*r.nextGaussian();
		double win=50*r.nextGaussian();

		double w=mod2pi(v,win);
		assert(doubleEquals(Math.cos(w),Math.cos(win)));
		assert(doubleEquals(Math.sin(w),Math.sin(win)));
		assert((v-w)<=Math.PI && (v-w)>=-Math.PI);
	    }

	System.out.println("\nAll tests passed. Next assertion will fail\n");
	assert(false);
    }
}
