package maslab.vis;

import maslab.util.*;
import maslab.geom.*;
import maslab.fig.*;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;
import java.io.*;

public class VisFigFile extends VisObject
{
    FigFile ff;
    Logger log=new Logger("VisFigFile");
    public double size=2; // in pixels

    Color wallColor=new Color(0,0,0,32);
    Color pathColor=new Color(0,0,255,32);

    GPoint2D offset;

    double figscale=0.001;

    public VisFigFile(File f) throws IOException
    {
	ff=new FigFile(f);
	findOffset();
    }

    public void findOffset()
    {
	offset=new GPoint2D(0,0);

	for (FigObject fo: ff.figObjects)
	    {
		if (fo instanceof FigPolyLine)
		    {
			FigPolyLine fpl=(FigPolyLine) fo;
			
			if (fpl.pencolor==1) // path
			    {
				offset=fpl.points.get(0).scale(figscale);
				return;
			    }
		    }
	    }
	log.warn("Didn't find a path!");
    }
    
    public void paint(VisCanvas vc, Graphics2D g, BufferedImage bi)
    {
	double scale=vc.getScale();

	double sz=size/scale;

	for (FigObject fo: ff.figObjects)
	    {
		if (fo instanceof FigPolyLine)
		    {
			FigPolyLine fpl=(FigPolyLine) fo;
			
			if (fpl.pencolor==0) // wall
			    {
				for (int i=1;i<fpl.points.size();i++)
				    {
					GPoint2D p1=fpl.points.get(i-1).scale(figscale).transform(0,-offset.getX(),-offset.getY());
					GPoint2D p2=fpl.points.get(i).scale(figscale).transform(0,-offset.getX(),-offset.getY());

					g.setColor(wallColor);
					g.setStroke(new BasicStroke((float) sz));
					
					Line2D.Double l=new Line2D.Double(p1.getX(), p1.getY(), p2.getX(), p2.getY());
					g.draw(l);
				    }
			    }
			else if (fpl.pencolor==1) // path
			    {
				for (GPoint2D p : fpl.points)
				    {
					p=p.scale(figscale).transform(0,-offset.getX(),-offset.getY());
					g.setColor(pathColor);
					g.fill(new Ellipse2D.Double(p.getX()-sz/2, p.getY()-sz/2, sz, sz)); 
				    }
				for (int i=1;i<fpl.points.size();i++)
				    {
					GPoint2D p1=fpl.points.get(i-1).scale(figscale).transform(0,-offset.getX(),-offset.getY());
					GPoint2D p2=fpl.points.get(i).scale(figscale).transform(0,-offset.getX(),-offset.getY());

					g.setColor(pathColor);
					g.setStroke(new BasicStroke((float) sz));
					
					Line2D.Double l=new Line2D.Double(p1.getX(), p1.getY(), p2.getX(), p2.getY());
					g.draw(l);
				    }

			    }
			else
			    log.warn("Unknown color "+fpl.pencolor+" in poly line");
		    }
		else
		    {
			log.warn("Unknown fig object type "+fo);
		    }
	    }
	
    }
}
