package maslab.vis;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;

/** A graphical depiction of a robot. **/
public class VisRobot extends VisObject
{
    public double x,y,theta;
    public double size=0.4;

    public String label;
    public Color color=Color.blue;
    public Color textColor=Color.blue;
    public double textSize=0.8;
    public double strokeSizePx=1;

    /** Create a new robot at the specified x,y, theta.
     * @param label A text string to be displayed at the robot position. May be null.
     **/
    public VisRobot(Color c, double x, double y, double theta, String label)
    {
	this.color=c;
	this.label=label;
	update(x,y,theta);
    }

    public void update(double x, double y, double theta)
    {
	this.x=x;
	this.y=y;
	this.theta=theta;
    }

    public void paint(VisCanvas vc, Graphics2D g, BufferedImage bi)
    {
	double scale=vc.getScale();

	g.setStroke(new BasicStroke((float) (1/scale)));

	if (label!=null && label.length()>0)
	    {
		double sz=size/scale;
		g.setColor(textColor);
		g.setFont(vc.getFont("Helvetica",Font.PLAIN, textSize));
		
		g.drawString(label, (float) (x+sz/2),(float) (y+sz/2));
	    }

	g.translate(x, y);
	g.rotate(theta);

	g.setColor(color);
	g.setStroke(new BasicStroke((float) (strokeSizePx/scale)));

	g.draw(new Line2D.Double(-size, size, -size, -size));
	g.draw(new Line2D.Double(-size, size, 2*size, 0));
	g.draw(new Line2D.Double(-size, -size, 2*size, 0));

    }

}
